/*!\file Input.c
 * \brief: implementation of the Input object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
#include "./objects.h"

		
Input::Input(){
	return;
}

Input::~Input(){

	xfree((void**)&vector);
	return;
}

Input::Input(char* input_name,char* input_string){
	
	strcpy(name,input_name);
	type=STRING;
	strcpy(string,input_string);
	ndof=0;
	numberofnodes=0;
	vector=NULL;
}
		
Input::Input(char* input_name,int input_integer){

	strcpy(name,input_name);
	type=INTEGER;
	integer=input_integer;

	ndof=0;
	numberofnodes=0;
	vector=NULL;

}
		
Input::Input(char* input_name,double input_scalar){

	strcpy(name,input_name);
	type=DOUBLE;
	scalar=input_scalar;

	ndof=0;
	numberofnodes=0;
	vector=NULL;

}

Input::Input(char* input_name,double* input_vector,int input_ndof,int input_numberofnodes){

	strcpy(name,input_name);
	type=DOUBLEVEC;
	vector=(double*)xmalloc(input_ndof*input_numberofnodes*sizeof(double));
	memcpy(vector,input_vector,input_ndof*input_numberofnodes*sizeof(double));
	ndof=input_ndof;
	numberofnodes=input_numberofnodes;

}

Input::Input(char* input_name,Vec input_vector,int input_ndof, int input_numberofnodes){

	strcpy(name,input_name);
	type=DOUBLEVEC;
	VecToMPISerial(&vector,input_vector);
	ndof=input_ndof;
	numberofnodes=input_numberofnodes;

}

void Input::Echo(void){

	int i,j;
	
	printf("Input:\n");
	printf("   name: %s\n",name);
	printf("   type: %i\n",type);
	if(type==STRING) printf("   string: %s\n",string);
	if(type==INTEGER) printf("   integer: %i\n",integer);
	if(type==DOUBLE) printf("   double: %g\n",scalar);
	if(type==DOUBLEVEC) printf("   doublevec:\n");
	for(i=0;i<numberofnodes;i++){
		printf("      node %i: ",i);
		for(j=0;j<ndof;j++)printf("%g ",*(vector+i*ndof+j));
		printf("\n");
	}
}
		
int Input::Enum(void){

	return InputEnum();

}

int    Input::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
		

int   Input::IsSameName(char* input_name){
	if (strcmp(input_name,name)==0)return 1;
	else return 0;
}
		

void  Input::Recover(double* values, int ndof, int* dofs,int numnodes,void** vpnodes){

	//ex: 
	// double values[6];
	// int ndof=2;
	// int dofs[2]={0,2}    //dofs 0 and 2
	// for a tria, 3 nodes
	//input->Recover(&values[0],ndof,dofs,3,this->nodes); //ie: recover values for dofs 0 and 2 of all nodes of the tria

	int* doflist=NULL;
	int  dof1;
	int  dof;
	int  i,j;
	Node** nodes=NULL;
	Node* node=NULL;

	/*recover pointer to nodes: */
	nodes=(Node**)vpnodes;
	
	if (type!=DOUBLEVEC) throw ErrorException(__FUNCT__,exprintf("%s%i%s"," cannot recover values from a ",type," input type"));
	
	/*Ok, we are trying to fill values. values is of size ndof*numnodes.  The dofs 
	 * for picking up the values are found in the numnodes nodes. We firt build the dof list: */
	doflist=(int*)xmalloc(ndof*numnodes*sizeof(int));

	for(i=0;i<numnodes;i++){
		node=nodes[i];

		/*Get 1d dof of this node: */
		dof1=node->GetDoflist1();

		for(j=0;j<ndof;j++){
			dof=dofs[j];
			doflist[i*ndof+j]=dof1*ndof+dof;
		}
	}

	xfree((void**)&doflist);
}

Object* Input::copy() {
	
	return new Input(*this); 

}


void  Input::Recover(int* pinteger){
	*pinteger=integer;
}
	
void  Input::Recover(char** pstring){
	char* outstring=NULL;

	outstring=(char*)xmalloc((strlen(string)+1)*sizeof(char));
	strcpy(outstring,string);
	*pstring=outstring;

}

void  Input::Recover(double* pdouble){

	*pdouble=scalar;

}

#undef __FUNCT__
#define __FUNCT__ "Input::GetId"
int   Input::GetId(){
	throw ErrorException(__FUNCT__,"not supported yet!");
}

#undef __FUNCT__
#define __FUNCT__ "Input::Marshall"
void  Input::Marshall(char** pmarshalled_dataset){
	throw ErrorException(__FUNCT__,"not supported yet!");
}

#undef __FUNCT__
#define __FUNCT__ "Input::MarshallSize"
int   Input::MarshallSize(){
	throw ErrorException(__FUNCT__,"not supported yet!");
}

#undef __FUNCT__
#define __FUNCT__ "Input::GetName"
char* Input::GetName(){
	throw ErrorException(__FUNCT__,"not supported yet!");
}
		
#undef __FUNCT__
#define __FUNCT__ "Input::Demarshall"
void  Input::Demarshall(char** pmarshalled_dataset){
	throw ErrorException(__FUNCT__,"not supported yet!");
}
