function plotoptions=buildlist(plotoptions,varargin),
%BUILDLIST - build list of plotoptions from input
%
%   Usage:
%      plotoptions=buildlist(plotoptions,varargin)

%check length of input
if mod((nargin-1),2),
	error('buildlist error message: an even number of plotoptions is required')
end

%first: build a pairoptions out of varargin:
rawoptions=pairoptions(varargin{:});

%get figure number
plotoptions.figurenumber=getfieldvalue(rawoptions,'figure',1);

%get number of data to be plotted
numberofplots=fieldoccurences(rawoptions,'data');
plotoptions.numberofplots=numberofplots;

%initialize plotoptions.list
plotoptions.list=cell(numberofplots,1);
for i=1:numberofplots,
	plotoptions.list{i}=pairoptions;
end

%process plot options
for i=1:size(rawoptions.list,1),

	%option contains '#'
	if ismember('#',rawoptions.list{i,1}),

		%get suplot(s) associated
		string=strsplit(rawoptions.list{i,1},'#');
		plotnums=string{end};
		field=string{1};

		%divide plotnums if there is a comma ','
		plotnums=strsplit_strict(plotnums,',');

		%loop over plotnums
		for k=1:length(plotnums);
			plotnum=plotnums{k};

			%Empty
			if isempty(plotnum),
				continue;

			%#all
			elseif strcmpi(plotnum,'all');
				for j=1:numberofplots,
					plotoptions.list{j}=addfield(plotoptions.list{j},field,rawoptions.list{i,2});
				end

			%#i-j
			elseif ismember('-',plotnum)
				nums=strsplit(plotnum,'-');
				if length(nums)~=2, continue; end
				for j=nums(1):nums(2),
					plotoptions.list{j}=addfield(plotoptions.list{j},field,rawoptions.list{i,2});
				end

			%#i
			else
				%assign to subplot
				plotoptions.list{str2num(plotnum)}=addfield(plotoptions.list{str2num(plotnum)},field,rawoptions.list{i,2});
			end
		end

	%assign option field to corresponding subplot
	else

		%go through all subplot and assign to the first one free
		j=1;
		while (j<=numberofplots),
			if ~exist(plotoptions.list{j},rawoptions.list{i,1});
				plotoptions.list{j}=addfield(plotoptions.list{j},rawoptions.list{i,1},rawoptions.list{i,2});
				break
			else
				j=j+1;
			end
		end
		if j>numberofplots,
			disp(['plot info message: too many ''' rawoptions.list{i,1} ''' options']);
		end
	end
end

%check that there is no duplicates
for i=1:numberofplots,
	plotoptions.list{i}=deleteduplicates(plotoptions.list{i},1);
end
