%Test Name: SquareShelfTranIspddIsdeltaO18pdNoInterpSSA2d
md=triangle(model(),'../Exp/Square.exp',60000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');

%md.verbose=verbose('all');

% Use of ispdd and isdelta18o methods
md.smb = SMBd18opdd();
md.smb.isd18opd=1;

% Add temperature, precipitation and delta18o needed to measure the surface mass balance
%  creating delta18o
load '../Data/delta18o.data'
md.smb.delta18o=delta18o;
md.smb.istemperaturescaled = 0;
md.smb.isprecipscaled = 0;

% creating Present day  temperatures
% Same temperature over the all region:
tmonth(1:12)=238.15+20.;
for imonth=0:11
	md.smb.temperatures_presentday(1:md.mesh.numberofvertices,imonth+1)=tmonth(imonth+1);
end
md.smb = initialize(md.smb,md);

% creating precipitation
for imonth=0:11
	md.smb.precipitations_presentday(1:md.mesh.numberofvertices,imonth+1)=-0.4*10^(-6)*md.mesh.y+0.5;
end

% 3 total years of input
md.smb.temperatures_reconstructed = nan(md.mesh.numberofvertices+1,12*3);
md.smb.precipitations_reconstructed = nan(md.mesh.numberofvertices+1,12*3);

md.smb.temperatures_reconstructed(1:end-1,1:12) = md.smb.temperatures_presentday(1:end,:);
md.smb.temperatures_reconstructed(1:end-1,13:24) = md.smb.temperatures_presentday(1:end,:)+1.2;
md.smb.temperatures_reconstructed(1:end-1,25:36) = md.smb.temperatures_presentday(1:end,:)-0.8;

md.smb.precipitations_reconstructed(1:end-1,1:12) = md.smb.precipitations_presentday(1:end,:);
md.smb.precipitations_reconstructed(1:end-1,13:24) = md.smb.precipitations_presentday(1:end,:)+0.1;
md.smb.precipitations_reconstructed(1:end-1,25:36) = md.smb.precipitations_presentday(1:end,:)-0.1;

tim1 = [1/12:1/12:1];

md.smb.temperatures_reconstructed(end,1:12) = tim1; md.smb.temperatures_reconstructed(end,13:24) = tim1+3; md.smb.temperatures_reconstructed(end,25:36) = tim1+5;
md.smb.precipitations_reconstructed(end,1:12) = tim1; md.smb.precipitations_reconstructed(end,13:24) = tim1+3; md.smb.precipitations_reconstructed(end,25:36) = tim1+5;

% creating initialization and spc temperatures initialization and
% spc
md.thermal.spctemperature=mean(md.smb.temperatures_presentday(1:md.mesh.numberofvertices,1:12),2)-10; %-10*ones(md.mesh.numberofvertices,1);
md.initialization.temperature=md.thermal.spctemperature; %md.smb.temperatures_presentday(1:md.mesh.numberofvertices,1);


md.smb.s0p = (max(md.geometry.surface,0));
md.smb.s0t = (max(md.geometry.surface,0));
md.smb.issetpddfac = 1;
md.smb.pddfac_snow =4.3;
md.smb.pddfac_ice = 8.3;

md=extrude(md,5,1.2);
md=setflowequation(md,'HO','all');
md.settings.results_on_nodes={'Temperature','Waterfraction','Enthalpy'};

md.thermal.isenthalpy=1;
md.thermal.isdynamicbasalspc=1;
md.thermal.fe = 'P1xP2';
%md.thermal.spctemperature(find(md.mesh.vertexonbase)) = NaN;

md.initialization.waterfraction= zeros(md.mesh.numberofvertices,1);
md.initialization.watercolumn  = zeros(md.mesh.numberofvertices,1);
md.initialization.enthalpy = zeros(md.mesh.numberofvertices,1);
md.thermal.isdrainicecolumn=0;

md=solve(md,'thermal');

md.initialization.temperature=md.results.ThermalSolution.Temperature;
md.initialization.enthalpy=md.results.ThermalSolution.Enthalpy;
%x = find(md.initialization.temperature<210);
%md.initialization.temperature(x) = 268;
md.materials.rheology_B = cuffey(md.initialization.temperature);

% Friction
TEMP = zeros(md.mesh.numberofvertices,1);
TEMP(md.mesh.elements) = md.initialization.temperature(:,1:6);

temperature =TEMP;
pressure = md.initialization.pressure;%md.materials.rho_ice*md.constants.g*md.geometry.thickness;
Tm = md.materials.meltingpoint-md.materials.beta*pressure;

md.friction.coefficient = md.friction.coefficient;%averaging(md,md.friction.coefficient,2);
md.friction=frictionjosh(md.friction);
md.friction.pressure_adjusted_temperature = temperature - Tm;
md.friction.gamma= 5;

% time steps and resolution
md.timestepping.time_step=0.5;
md.settings.output_frequency=1;
md.timestepping.final_time=2;
md.timestepping.interp_forcings=0;

%md.transient.requested_outputs={'default','IceVolumeAboveFloatation','IceVolume','TemperaturePDD','SmbMonthlytemperatures','SmbPrecipitation'};
md.transient.requested_outputs={'default','IceVolumeAboveFloatation','IceVolume','TemperaturePDD'};
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',1); % 3 for the cluster
md=solve(md,'Transient');

field_names = {...
	'Vx1','Vy1','Vz1','Vel1','Pressure1','Bed1','Surface1','Thickness1','Temperature1','Enthalpy1','SmbMassBalance1', ...
	'Vx2','Vy2','Vz2','Vel2','Pressure2','Bed2','Surface2','Thickness2','Temperature2','Enthalpy2','SmbMassBalance2', ...
	'Vx3','Vy3','Vz3','Vel3','Pressure3','Bed3','Surface3','Thickness3','Temperature3','Enthalpy3','SmbMassBalance3', ...
	'Vx4','Vy4','Vz4','Vel4','Pressure4','Bed4','Surface4','Thickness4','Temperature4','Enthalpy4','SmbMassBalance4'};
field_tolerances={...
	1e-09,1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-13,...
	1e-09,1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-13,...
	1e-09,1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-13,...
	1e-09,1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-13};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vz),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).Temperature),...
	(md.results.TransientSolution(1).Enthalpy),...
	(md.results.TransientSolution(1).SmbMassBalance),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vz),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).Temperature),...
	(md.results.TransientSolution(2).Enthalpy),...
	(md.results.TransientSolution(2).SmbMassBalance),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vz),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).Temperature),...
	(md.results.TransientSolution(3).Enthalpy),...
	(md.results.TransientSolution(3).SmbMassBalance),...
	(md.results.TransientSolution(4).Vx),...
	(md.results.TransientSolution(4).Vy),...
	(md.results.TransientSolution(4).Vz),...
	(md.results.TransientSolution(4).Vel),...
	(md.results.TransientSolution(4).Pressure),...
	(md.results.TransientSolution(4).Base),...
	(md.results.TransientSolution(4).Surface),...
	(md.results.TransientSolution(4).Thickness),...
	(md.results.TransientSolution(4).Temperature),...
	(md.results.TransientSolution(4).Enthalpy),...
	(md.results.TransientSolution(4).SmbMassBalance),...
	};
