%Test Name: SquareShelfTranIspddIsdeltaO18pdInterpSSA2d
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');

%md.verbose=verbose('all');

% Use of ispdd and isdelta18o methods
md.smb = SMBd18opdd();
md.smb.isd18opd=1;
%md.smb.precipitation(1:md.mesh.numberofvertices,1:12)=0;
%md.smb.monthlytemperatures(1:md.mesh.numberofvertices,1:12)=273;

% Add temperature, precipitation and delta18o needed to measure the surface mass balance
%  creating delta18o
load '../Data/delta18o.data'
md.smb.delta18o=delta18o;

% creating Present day  temperatures
% Same temperature over the all region:
tmonth(1:12)=238.15+20.;
for imonth=0:11
    md.smb.temperatures_presentday(1:md.mesh.numberofvertices,imonth+1)=tmonth(imonth+1);
end

% creating initialization and spc temperatures initialization and
% spc
md.thermal.spctemperature=mean(md.smb.temperatures_presentday(1:md.mesh.numberofvertices,1:12),2)-10; %-10*ones(md.mesh.numberofvertices,1);

md.initialization.temperature=md.thermal.spctemperature; %md.smb.temperatures_presentday(1:md.mesh.numberofvertices,1);

% creating precipitation
for imonth=0:11
    md.smb.precipitations_presentday(1:md.mesh.numberofvertices,imonth+1)=-0.4*10^(-6)*md.mesh.y+0.5;
end
md.smb = initialize(md.smb,md);

% time steps and resolution
md.timestepping.time_step=0.5;
md.settings.output_frequency=1;
md.timestepping.final_time=2;

md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',1); % 3 for the cluster
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','SmbMassBalance1',...
	      'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','SmbMassBalance2',...
	      'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3','SmbMassBalance3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).SmbMassBalance),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).SmbMassBalance),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).SmbMassBalance),...
	};
