#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.6.3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.6.3.tar.gz' 'petsc-3.6.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.6.3.tar.gz
mv petsc-3.6.3/* src/
rm -rf petsc-3.6.3

# configure
cd src
./configure --prefix="$ISSM_DIR/externalpackages/petsc/install-$VER-intel-mvapich2-2" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src-$VER-intel-mvapich2-2"\
	--with-mpi-dir="/usr/local/mpi/intel18/mvapich2-2.2/" \
	--known-mpi-shared-libraries \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-shared-libraries=1 \
	--with-batch=1 \
	--download-mumps=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-fblaslapack=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cd $ISSM_DIR/externalpackages/petsc/src

PBS_O_WORKDIR=$PWD

cat > script.pbs << EOF
#PBS -S /bin/bash
#PBS -q batch
#PBS -l nodes=1:ppn=1

# Set qsub location
PBS_O_WORKDIR=$PWD
cd $PBS_O_WORKDIR

# set mpi module
module load intel18/compiler-18
module load intel18/mvapich2-2.2
module rm   intel18/openmpi-2.0.2
module rm   intel18/impi-18

echo "check module"
module list

mpirun -machinefile $PBS_O_WORKDIR/mpi.host -np 1 $PBS_O_WORKDIR/conftest-arch-linux2-c-opt  
EOF

# generate mpi.host file
cat > mpi.host <<EOF
simba02:36
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub script.pbs "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
echo "== If it works good, do ./reconfigure-arch-linux2-c-opt.py"
