#!/bin/bash
set -eu


# TODO:
# - Revisit enviroment variables (especially EMCC_CFLAGS) once support for
#	Fortran has been accomplished.
#

# Environment
export CC=emcc
export CXX=em++
export AR=emar
export RANLIB=emranlib
#export EMCC_DEBUG=1 # Uncomment to enable debugging
export EMCC_CFLAGS="-s ERROR_ON_UNDEFINED_SYMBOLS=0" # Required after v1.38.14 to avoid undefined symbol warnings from our Fortran object files being treated as errors

# Source Emscripten environment
source $ISSM_DIR/externalpackages/emscripten/install/emsdk_env.sh

# Issue with variadic function signatures.
#export CFLAGS=-DSTDC_HEADERS

# Cleanup from previous installation
rm -rf src-javascript install-javascript gsl-1.15
mkdir src-javascript install-javascript

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/gsl-1.15.tar.gz' 'gsl-1.15.tar.gz'

#Untar
tar -zxvf  gsl-1.15.tar.gz

#Move gsl into src directory
mv gsl-1.15/* src-javascript
rm -rf gsl-1.15

#Configure gsl
cd src-javascript

./configure \
	--prefix="$ISSM_DIR/externalpackages/gsl/install-javascript" \
	--disable-shared

#Compile gsl
if [ $# -eq 0 ]; then
	make
else
	make -j $1
fi
make install
