#!/bin/bash
set -eu


## Constants
#
VER="3.16.2"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/cmake-${VER}.tar.gz" "cmake-${VER}.tar.gz"

# Unpack source
tar -zxvf cmake-${VER}.tar.gz

# Cleanup
rm -rf install

# Move source into 'install' directory
mv cmake-${VER} install

# Configure
cd install
#./bootstrap \
#	--prefix=${ISSM_DIR}/externalpackages/cmake/install # Breaks on ronne
./configure \
	--prefix=${ISSM_DIR}/externalpackages/cmake/install

# Compile
if [ $# -eq 0 ]; then
	make
else
	make -j $1;
fi
