//dsl Class definition
//
//   Usage:
//      dsl=dsl();

function dsl(){
	//methods
	this.setdefaultparameters = function(){// {{{
		this.requested_outputs=['default'];
	} // }}}
	this.disp = function(){ // {{{
		console.log(sprintf('   dsl parameters:'));
		fielddisplay(this,'global_average_thermosteric_sea_level_change','corresponds to zostoga field in CMIP5 archives. Specified as a temporally variable global rate (mm/yr)');
		fielddisplay(this,'sea_surface_height_change_above_geoid','corresponds to zos field in CMIP5 archives. Spatial average is 0. Specified as a spatio-temporally variable rate (mm/yr)');
		fielddisplay(this,'sea_water_pressure_change_at_sea_floor','corresponds to bpo field in CMIP5 archives. Specified as a spatio-temporally variable rate (in Pa/yr)');


	} // }}}
	this.defaultoutputs = function(){ // {{{
		return '';
	}//}}}
    this.classname = function(){ // {{{
        return "dsl";
    } // }}}
    this.extrude = function(md) {//{{{
        this.sea_surface_height_change_above_geoid=project3d(md,'vector',this.sea_surface_height_change_above_geoid,'type','node');
        this.sea_water_pressure_change_at_sea_floor=project3d(md,'vector',this.sea_water_pressure_change_at_sea_floor,'type','node');
        return this;
    }//}}}
    this.checkconsistency = function(md,solution,analyses) { //{{{

        if(ArrayAnyEqual(ArrayIsMember('SealevelriseAnalysis',analyses),1)){
            checkfield(md,'fieldname','dsl.sea_surface_height_change_above_geoid','timeseries',1,'NaN',1,'Inf',1);
            checkfield(md,'fieldname','dsl.sea_water_pressure_change_at_sea_floor','timeseries',1,'NaN',1,'Inf',1);
        }

    } // }}}
    this.marshall=function(md,prefix,fid) { //{{{

        var yts=md.constants.yts;

		WriteData(fid,prefix,'name','md.dsl.model','data',1,'format','Integer');
		WriteData(fid,prefix,'object',this,'class','dsl','fieldname','global_average_thermosteric_sea_level_change','format','DoubleMat','mattype',1,'timeserieslength',1+1,'yts',md.constants.yts,'scale',1e-3/md.constants.yts);
			WriteData(fid,prefix,'object',this,'class','dsl','fieldname','sea_water_pressure_change_at_sea_floor','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts,'scale',1e-3/md.constants.yts);
			WriteData(fid,prefix,'object',this,'class',dsl,'fieldname','sea_surface_height_change_above_geoid','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts);
    }//}}}
    this.fix=function() { //{{{
    }//}}}
	//properties 
    // {{{
	this.global_average_thermosteric_sea_level_change = NaN;
	this.sea_surface_height_change_above_geoid = NaN;
	this.sea_water_pressure_change_at_sea_floor = NaN;
    // }}}
}
