#!/bin/bash
#set -eu # Do not `run set -eu` because it causes some targets to fail


## Constants
#
VER="1_72_0"

## Environment
#
export BOOST_ROOT="${ISSM_DIR}/externalpackages/boost"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/boost_${VER}.tar.gz" "boost_${VER}.tar.gz"

# Unpack source
tar -zxvf boost_${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source into 'src' directory
mv boost_${VER}/* src/
rm -rf boost_${VER}

# Configure
cd src
./bootstrap.sh \
	--prefix=${BOOST_ROOT}/install \
	--with-python=python2.7

# Modify project config to enable MPI
printf "\n# Enable MPI\nusing mpi ;\n" >> project-config.jam

# Compile and install
./b2 toolset=darwin link=static install

# Copy binary to install directory
mkdir ${BOOST_ROOT}/install/bin
cp bjam ${BOOST_ROOT}/install/bin

# Remove any dynamic libraries that may have been compiled
#
# TODO: Reconfigure so that dynamic libraries are not compiled at all
#
rm -f $(ls ${BOOST_ROOT}/install/lib/*.dylib)
