function maxtime=timesteps(md,vx,vy);
%TIMESTEPS - return the maximum timesteps for the model in years
%
%   Dt < c Dx/u
%
%   Usage:
%      maxtime=timesteps(md,vx,vy);
%
%   Example:
%      dt=timesteps(md,md.results.diagnostic.vx,md.results.diagnostic.vy);

%Check length of velocities 
if size(vx,1)~=md.numberofgrids & size(vy,1)~=md.numberofgrids,
	error('timestpes error message: size of velocity components must be the same as md.numberofgrids');
end

areas=GetAreas(md.elements,md.x,md.y);
Dx=averaging(md,sqrt(2*areas),0);
Du=sqrt(vx.^2+vy.^2);
maxtime=min(1/2*Dx./Du);


