/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	ParametersSTARTEnum,
	/*Parameters{{{*/
	AdolcParamEnum,
	AmrDeviatoricErrorGroupThresholdEnum,
	AmrDeviatoricErrorMaximumEnum,
	AmrDeviatoricErrorResolutionEnum,
	AmrDeviatoricErrorThresholdEnum,
	AmrErrEnum,
	AmrFieldEnum,
	AmrGradationEnum,
	AmrGroundingLineDistanceEnum,
	AmrGroundingLineResolutionEnum,
	AmrHmaxEnum,
	AmrHminEnum,
	AmrIceFrontDistanceEnum,
	AmrIceFrontResolutionEnum,
	AmrKeepMetricEnum,
	AmrLagEnum,
	AmrLevelMaxEnum,
	AmrRestartEnum,
	AmrThicknessErrorGroupThresholdEnum,
	AmrThicknessErrorMaximumEnum,
	AmrThicknessErrorResolutionEnum,
	AmrThicknessErrorThresholdEnum,
	AmrTypeEnum,
	AnalysisCounterEnum,
	AnalysisTypeEnum,
	AugmentedLagrangianREnum,
	AugmentedLagrangianRholambdaEnum,
	AugmentedLagrangianRhopEnum,
	AugmentedLagrangianRlambdaEnum,
	AugmentedLagrangianThetaEnum,
	AutodiffCbufsizeEnum,
	AutodiffDependentObjectsEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffGcTriggerMaxSizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffIsautodiffEnum,
	AutodiffLbufsizeEnum,
	AutodiffNumDependentsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffObufsizeEnum,
	AutodiffTapeAllocEnum,
	AutodiffTbufsizeEnum,
	AutodiffXpEnum,
	BalancethicknessStabilizationEnum,
	BasalforcingsBottomplumedepthEnum,
	BasalforcingsCrustthicknessEnum,
	BasalforcingsDeepwaterElevationEnum,
	BasalforcingsDeepwaterMeltingRateEnum,
	BasalforcingsDtbgEnum,
	BasalforcingsEnum,
	BasalforcingsIsmip6AverageTfEnum,
	BasalforcingsIsmip6BasinAreaEnum,
	BasalforcingsIsmip6DeltaTEnum,
	BasalforcingsIsmip6Gamma0Enum,
	BasalforcingsIsmip6IsLocalEnum,
	BasalforcingsIsmip6NumBasinsEnum,
	BasalforcingsIsmip6TfDepthsEnum,
	BasalforcingsLowercrustheatEnum,
	BasalforcingsMantleconductivityEnum,
	BasalforcingsMeltrateFactorEnum,
	BasalforcingsNusseltEnum,
	BasalforcingsPicoAverageOverturningEnum,
	BasalforcingsPicoAverageSalinityEnum,
	BasalforcingsPicoAverageTemperatureEnum,
	BasalforcingsPicoBoxAreaEnum,
	BasalforcingsPicoFarOceansalinityEnum,
	BasalforcingsPicoFarOceantemperatureEnum,
	BasalforcingsPicoGammaTEnum,
	BasalforcingsPicoIsplumeEnum,
	BasalforcingsPicoMaxboxcountEnum,
	BasalforcingsPicoNumBasinsEnum,
	BasalforcingsPlumeradiusEnum,
	BasalforcingsPlumexEnum,
	BasalforcingsPlumeyEnum,
	BasalforcingsThresholdThicknessEnum,
	BasalforcingsTopplumedepthEnum,
	BasalforcingsUppercrustheatEnum,
	BasalforcingsUppercrustthicknessEnum,
	BasalforcingsUpperdepthMeltEnum,
	BasalforcingsUpperwaterElevationEnum,
	BasalforcingsUpperwaterMeltingRateEnum,
	CalvingCrevasseDepthEnum,
	CalvingHeightAboveFloatationEnum,
	CalvingLawEnum,
	CalvingMaxEnum,
	CalvingMinthicknessEnum,
	ConfigurationTypeEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	ControlInputSizeMEnum,
	ControlInputSizeNEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageEnum,
	DamageEquivStressEnum,
	DamageEvolutionNumRequestedOutputsEnum,
	DamageEvolutionRequestedOutputsEnum,
	DamageHealingEnum,
	DamageKappaEnum,
	DamageLawEnum,
	DamageMaxDamageEnum,
	DamageStabilizationEnum,
	DamageStressThresholdEnum,
	DamageStressUBoundEnum,
	DebugProfilingEnum,
	DomainDimensionEnum,
	DomainTypeEnum,
	DslModelEnum,
	DslModelidEnum,
	DslNummodelsEnum,
	DslComputeFingerprintsEnum,
	EarthIdEnum,
	EplZigZagCounterEnum,
	EsaHElasticEnum,
	EsaHemisphereEnum,
	EsaRequestedOutputsEnum,
	EsaUElasticEnum,
	ExtrapolationVariableEnum,
	FemModelCommEnum,
	FlowequationFeFSEnum,
	FlowequationIsFSEnum,
	FlowequationIsHOEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FrictionCouplingEnum,
	FrictionDeltaEnum,
	FrictionFEnum,
	FrictionGammaEnum,
	FrictionLawEnum,
	FrictionPseudoplasticityExponentEnum,
	FrictionThresholdSpeedEnum,
	FrictionVoidRatioEnum,
	FrontalForcingsBasinIcefrontAreaEnum,
	FrontalForcingsNumberofBasinsEnum,
	FrontalForcingsParamEnum,
	GiaCrossSectionShapeEnum,
	GroundinglineFrictionInterpolationEnum,
	GroundinglineMeltInterpolationEnum,
	GroundinglineMigrationEnum,
	HydrologyCavitySpacingEnum,
	HydrologyChannelConductivityEnum,
	HydrologyChannelSheetWidthEnum,
	HydrologyEnglacialVoidRatioEnum,
	HydrologyIschannelsEnum,
	HydrologyMeltFlagEnum,
	HydrologyModelEnum,
	HydrologyNumRequestedOutputsEnum,
	HydrologyPressureMeltCoefficientEnum,
	HydrologyRelaxationEnum,
	HydrologyRequestedOutputsEnum,
	HydrologySedimentKmaxEnum,
	HydrologyStepsPerStepEnum,
	HydrologyStorageEnum,
	HydrologydcEplColapseThicknessEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplMaxThicknessEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplThickCompEnum,
	HydrologydcEplflipLockEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcMaxIterEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologydcRelTolEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcUnconfinedFlagEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologyshreveStabilizationEnum,
	IcecapToEarthCommEnum,
	IndexEnum,
	InputFileNameEnum,
	InputToDepthaverageInEnum,
	InputToDepthaverageOutEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	InputToSmoothEnum,
	InversionAlgorithmEnum,
	InversionControlParametersEnum,
	InversionControlScalingFactorsEnum,
	InversionCostFunctionsEnum,
	InversionDxminEnum,
	InversionGatolEnum,
	InversionGradientScalingEnum,
	InversionGrtolEnum,
	InversionGttolEnum,
	InversionIncompleteAdjointEnum,
	InversionIscontrolEnum,
	InversionMaxiterEnum,
	InversionMaxiterPerStepEnum,
	InversionMaxstepsEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionTypeEnum,
	LevelsetKillIcebergsEnum,
	LevelsetReinitFrequencyEnum,
	LevelsetStabilizationEnum,
	LockFileNameEnum,
	LoveAllowLayerDeletionEnum,
	LoveForcingTypeEnum,
	LoveFrequenciesEnum,
	LoveG0Enum,
	LoveKernelsEnum,
	LoveMu0Enum,
	LoveNfreqEnum,
	LoveR0Enum,
	LoveShNmaxEnum,
	LoveShNminEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportRequestedOutputsEnum,
	MasstransportStabilizationEnum,
	MaterialsBetaEnum,
	MaterialsEarthDensityEnum,
	MaterialsEffectiveconductivityAveragingEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsMantleDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsMuWaterEnum,
	MaterialsRheologyLawEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoSeawaterEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MeltingOffsetEnum,
	MeshAverageVertexConnectivityEnum,
	MeshElementtypeEnum,
	MeshNumberoflayersEnum,
	MeshNumberofverticesEnum,
	ModelIdEnum,
	NodesEnum,
	NumModelsEnum,
	OceanGridNxEnum,
	OceanGridNyEnum,
	OceanGridXEnum,
	OceanGridYEnum,
	OutputBufferPointerEnum,
	OutputBufferSizePointerEnum,
	OutputFileNameEnum,
	OutputFilePointerEnum,
	OutputdefinitionEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuIsdakotaEnum,
	QmuNumberofpartitionsEnum,
	QmuOutNameEnum,
	QmuOutputEnum,
	QmuCurrEvalIdEnum,
	QmuEpartitionEnum,
	QmuVpartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariableDescriptorsEnum,
	RestartFileNameEnum,
	ResultsEnum,
	RootPathEnum,
	SaveResultsEnum,
	SealevelEustaticEnum,
	SealevelriseAbstolEnum,
	SealevelriseAngularVelocityEnum,
	SealevelriseElasticEnum,
	SealevelriseEquatorialMoiEnum,
	SealevelriseFluidLoveEnum,
	SealevelriseGElasticEnum,
	SealevelriseGeodeticEnum,
	SealevelriseGeodeticRunFrequencyEnum,
	SealevelriseHElasticEnum,
	SealevelriseHorizEnum,
	SealevelriseLoopIncrementEnum,
	SealevelriseMaxiterEnum,
	SealevelriseOceanAreaScalingEnum,
	SealevelrisePolarMoiEnum,
	SealevelriseReltolEnum,
	SealevelriseRequestedOutputsEnum,
	SealevelriseRigidEnum,
	SealevelriseRotationEnum,
	SealevelriseRunCountEnum,
	SealevelriseTidalLoveHEnum,
	SealevelriseTidalLoveKEnum,
	SealevelriseTransitionsEnum,
	SealevelriseUElasticEnum,
	SettingsIoGatherEnum,
	SettingsNumResultsOnNodesEnum,
	SettingsOutputFrequencyEnum,
	SettingsRecordingFrequencyEnum,
	SettingsResultsOnNodesEnum,
	SettingsSbCouplingFrequencyEnum,
	SettingsSolverResidueThresholdEnum,
	SettingsWaitonlockEnum,
	SmbAIceEnum,
	SmbAIdxEnum,
	SmbASnowEnum,
	SmbAccualtiEnum,
	SmbAccugradEnum,
	SmbAccurefEnum,
	SmbAdThreshEnum,
	SmbDesfacEnum,
	SmbDpermilEnum,
	SmbDsnowIdxEnum,
	SmbCldFracEnum,
	SmbDelta18oEnum,
	SmbDelta18oSurfaceEnum,
	SmbDenIdxEnum,
	SmbDtEnum,
	SmbEnum,
	SmbFEnum,
	SmbInitDensityScalingEnum,
	SmbIsaccumulationEnum,
	SmbIsalbedoEnum,
	SmbIsclimatologyEnum,
	SmbIsd18opdEnum,
	SmbIsdelta18oEnum,
	SmbIsdensificationEnum,
	SmbIsfirnwarmingEnum,
	SmbIsgraingrowthEnum,
	SmbIsmeltEnum,
	SmbIsmungsmEnum,
	SmbIsprecipscaledEnum,
	SmbIssetpddfacEnum,
	SmbIsshortwaveEnum,
	SmbIstemperaturescaledEnum,
	SmbIsthermalEnum,
	SmbIsturbulentfluxEnum,
	SmbKEnum,
	SmbNumRequestedOutputsEnum,
	SmbPfacEnum,
	SmbRdlEnum,
	SmbRequestedOutputsEnum,
	SmbRlapsEnum,
	SmbRlapslgmEnum,
	SmbRunoffaltiEnum,
	SmbRunoffgradEnum,
	SmbRunoffrefEnum,
	SmbSealevEnum,
	SmbStepsPerStepEnum,
	SmbSwIdxEnum,
	SmbT0dryEnum,
	SmbT0wetEnum,
	SmbTdiffEnum,
	SmbThermoDeltaTScalingEnum,
	SmbTemperaturesReconstructedYearsEnum,
	SmbPrecipitationsReconstructedYearsEnum,
	SmoothThicknessMultiplierEnum,
	SolutionTypeEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	StepEnum,
	StressbalanceAbstolEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReltolEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	ThermalIsdrainicecolumnEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalIsenthalpyEnum,
	ThermalMaxiterEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalReltolEnum,
	ThermalRequestedOutputsEnum,
	ThermalStabilizationEnum,
	ThermalWatercolumnUpperlimitEnum,
	TimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingCouplingTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingInterpForcingsEnum,
	TimesteppingStartTimeEnum,
	TimesteppingTimeStepEnum,
	TimesteppingTimeStepMaxEnum,
	TimesteppingTimeStepMinEnum,
	TimesteppingTypeEnum,
	ToMITgcmCommEnum,
	ToolkitsFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	ToolkitsTypesEnum,
	TransientAmrFrequencyEnum,
	TransientIscouplerEnum,
	TransientIsdamageevolutionEnum,
	TransientIsesaEnum,
	TransientIsgiaEnum,
	TransientIsgroundinglineEnum,
	TransientIshydrologyEnum,
	TransientIsmasstransportEnum,
	TransientIsmovingfrontEnum,
	TransientIsoceancouplingEnum,
	TransientIsslrEnum,
	TransientIssmbEnum,
	TransientIsstressbalanceEnum,
	TransientIsthermalEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	VelocityEnum,
	WorldCommEnum,
	/*}}}*/
	ParametersENDEnum,
	InputsSTARTEnum,
	/*Inputs{{{*/
	AdjointEnum,
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AirEnum,
	ApproximationEnum,
	BalancethicknessMisfitEnum,
	BalancethicknessOmega0Enum,
	BalancethicknessOmegaEnum,
	BalancethicknessThickeningRateEnum,
	BasalCrevasseEnum,
	BasalforcingsFloatingiceMeltingRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsGroundediceMeltingRateEnum,
	BasalforcingsPerturbationMeltingRateEnum,
	BasalforcingsIsmip6BasinIdEnum,
	BasalforcingsIsmip6TfEnum,
	BasalforcingsIsmip6TfShelfEnum,
	BasalforcingsIsmip6MeltAnomalyEnum,
	BasalforcingsOceanSalinityEnum,
	BasalforcingsOceanTempEnum,
	BasalforcingsPicoBasinIdEnum,
	BasalforcingsPicoBoxIdEnum,
	BasalforcingsPicoOverturningCoeffEnum,
	BasalforcingsPicoSubShelfOceanOverturningEnum,
	BasalforcingsPicoSubShelfOceanSalinityEnum,
	BasalforcingsPicoSubShelfOceanTempEnum,
	BasalStressxEnum,
	BasalStressyEnum,
	BasalStressEnum,
	BaseEnum,
	BaseOldEnum,
	BaseSlopeXEnum,
	BaseSlopeYEnum,
	BedEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	CalvingCalvingrateEnum,
	CalvingHabFractionEnum,
	CalvingMeltingrateEnum,
	CalvingStressThresholdFloatingiceEnum,
	CalvingStressThresholdGroundediceEnum,
	CalvinglevermannCoeffEnum,
	CalvingratexAverageEnum,
	CalvingratexEnum,
	CalvingrateyAverageEnum,
	CalvingrateyEnum,
	CalvingFluxLevelsetEnum,
	CalvingMeltingFluxLevelsetEnum,
	ConvergedEnum,
	CrevasseDepthEnum,
	DamageDEnum,
	DamageDOldEnum,
	DamageDbarEnum,
	DamageDbarOldEnum,
	DamageFEnum,
	DegreeOfChannelizationEnum,
	DepthBelowSurfaceEnum,
	DeviatoricStresseffectiveEnum,
	DeviatoricStressxxEnum,
	DeviatoricStressxyEnum,
	DeviatoricStressxzEnum,
	DeviatoricStressyyEnum,
	DeviatoricStressyzEnum,
	DeviatoricStresszzEnum,
	DeviatoricStress1Enum,
	DeviatoricStress2Enum,
	DistanceToCalvingfrontEnum,
	DistanceToGroundinglineEnum,
	Domain2DhorizontalEnum,
	Domain2DverticalEnum,
	Domain3DEnum,
	DragCoefficientAbsGradientEnum,
	DrivingStressXEnum,
	DrivingStressYEnum,
	DslGlobalAverageThermostericSeaLevelChangeEnum,
	DslSeaSurfaceHeightChangeAboveGeoidEnum,
	DslSeaWaterPressureChangeAtSeaFloor,
	DslStericRateEnum,
	DslDynamicRateEnum,
	DummyEnum,
   EffectivePressureEnum,
	EffectivePressureSubstepEnum,
	EffectivePressureTransientEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	EplHeadEnum,
   EplHeadOldEnum,
	EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	EplHeadSubstepEnum,
   EplHeadTransientEnum,
	EsaDeltathicknessEnum,
	EsaEmotionEnum,
	EsaNmotionEnum,
	EsaRotationrateEnum,
	EsaStrainratexxEnum,
	EsaStrainratexyEnum,
	EsaStrainrateyyEnum,
	EsaUmotionEnum,
	EsaXmotionEnum,
	EsaYmotionEnum,
	EtaDiffEnum,
	FlowequationBorderFSEnum,
	FrictionAsEnum,
	FrictionCEnum,
	FrictionCmaxEnum,
	FrictionCoefficientEnum,
	FrictionCoefficientcoulombEnum,
	FrictionEffectivePressureEnum,
	FrictionMEnum,
	FrictionPEnum,
	FrictionPressureAdjustedTemperatureEnum,
	FrictionQEnum,
	FrictionSedimentCompressibilityCoefficientEnum,
	FrictionTillFrictionAngleEnum,
	FrictionWaterLayerEnum,
	FrictionfEnum,
	FrontalForcingsBasinIdEnum,
	FrontalForcingsSubglacialDischargeEnum,
	FrontalForcingsThermalForcingEnum,
	GeometryHydrostaticRatioEnum,
	GiaLithosphereThicknessEnum,
	GiaMantleViscosityEnum,
	GiaWEnum,
	GiadWdtEnum,
	GradientEnum,
	GroundinglineHeightEnum,
	HydraulicPotentialEnum,
	HydraulicPotentialOldEnum,
	HydrologyBasalFluxEnum,
	HydrologyBumpHeightEnum,
	HydrologyBumpSpacingEnum,
	HydrologydcBasalMoulinInputEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplThicknessSubstepEnum,
	HydrologydcEplThicknessTransientEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskThawedEltEnum,
	HydrologydcMaskThawedNodeEnum,
	HydrologydcSedimentTransmitivityEnum,
   HydrologyDrainageRateEnum,
   HydrologyEnglacialInputEnum,
	HydrologyGapHeightEnum,
	HydrologyHeadEnum,
	HydrologyHeadOldEnum,
	HydrologyMoulinInputEnum,
	HydrologyNeumannfluxEnum,
	HydrologyReynoldsEnum,
	HydrologySheetConductivityEnum,
	HydrologySheetThicknessEnum,
	HydrologySheetThicknessOldEnum,
	HydrologyWatercolumnMaxEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	IceEnum,
	IceMaskNodeActivationEnum,
	InputEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionSurfaceObsEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	LevelsetfunctionSlopeXEnum,
	LevelsetfunctionSlopeYEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	MaskGroundediceLevelsetEnum,
	MaskIceLevelsetEnum,
	MaskLandLevelsetEnum,
	MaskOceanLevelsetEnum,
	MasstransportSpcthicknessEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyEEnum,
	MaterialsRheologyEbarEnum,
	MaterialsRheologyEcEnum,
	MaterialsRheologyEcbarEnum,
	MaterialsRheologyEsEnum,
	MaterialsRheologyEsbarEnum,
	MaterialsRheologyNEnum,
	MeshScaleFactorEnum,
	MeshVertexonbaseEnum,
	MeshVertexonboundaryEnum,
	MeshVertexonsurfaceEnum,
	MisfitEnum,
	NeumannfluxEnum,
	NewDamageEnum,
	NodeEnum,
	OmegaAbsGradientEnum,
	P0Enum,
	P1Enum,
	PartitioningEnum,
	PressureEnum,
	RadarEnum,
	RadarAttenuationMacGregorEnum,
	RadarAttenuationWolffEnum,
	RadarIcePeriodEnum,
	RadarPowerMacGregorEnum,
	RadarPowerWolffEnum,
	RheologyBAbsGradientEnum,
	RheologyBInitialguessEnum,
	RheologyBInitialguessMisfitEnum,
	RheologyBbarAbsGradientEnum,
	SealevelEnum,
	SealevelEustaticMaskEnum,
	SealevelEustaticOceanMaskEnum,
	SealevelNEsaEnum,
	SealevelNEsaRateEnum,
	SealevelNGiaEnum,
	SealevelNGiaRateEnum,
	SealevelRSLEnum,
	SealevelRSLEustaticEnum,
	SealevelRSLEustaticRateEnum,
	SealevelRSLRateEnum,
	SealevelUEastEsaEnum,
	SealevelUEsaEnum,
	SealevelUEsaRateEnum,
	SealevelUGiaEnum,
	SealevelUGiaRateEnum,
	SealevelUNorthEsaEnum,
	SealevelriseCumDeltathicknessEnum,
	SealevelriseCumDeltathicknessOldEnum,
	SealevelriseDeltathicknessEnum,
	SealevelriseSpcthicknessEnum,
	SealevelriseHydroRateEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadSubstepEnum,
	SedimentHeadTransientEnum,
	SedimentHeadResidualEnum,
	SedimentHeadStackedEnum,
	SigmaNNEnum,
	SigmaVMEnum,
	SmbAEnum,
	SmbAValueEnum,
	SmbAccumulationEnum,
	SmbAiniEnum,
	SmbBMaxEnum,
	SmbBMinEnum,
	SmbBNegEnum,
	SmbBPosEnum,
	SmbCEnum,
	SmbDEnum,
	SmbDailyairdensityEnum,
	SmbDailyairhumidityEnum,
	SmbDailydlradiationEnum,
	SmbDailydsradiationEnum,
	SmbDailypressureEnum,
	SmbDailyrainfallEnum,
	SmbDailysnowfallEnum,
	SmbDailytemperatureEnum,
	SmbDailywindspeedEnum,
	SmbDiniEnum,
	SmbDlwrfEnum,
	SmbDswrfEnum,
	SmbDzAddEnum,
	SmbDzEnum,
	SmbDzMinEnum,
	SmbDzTopEnum,
	SmbDziniEnum,
	SmbEAirEnum,
	SmbECEnum,
	SmbECiniEnum,
	SmbElaEnum,
	SmbEvaporationEnum,
	SmbFACEnum,
	SmbGdnEnum,
	SmbGdniniEnum,
	SmbGspEnum,
	SmbGspiniEnum,
	SmbHrefEnum,
	SmbIsInitializedEnum,
	SmbMAddEnum,
	SmbMassBalanceClimateEnum,
	SmbMassBalanceEnum,
   SmbMassBalanceSubstepEnum,
   SmbMassBalanceTransientEnum,
	SmbMeanLHFEnum,
	SmbMeanSHFEnum,
	SmbMeanULWEnum,
	SmbMeltEnum,
	SmbMonthlytemperaturesEnum,
	SmbNetLWEnum,
	SmbNetSWEnum,
	SmbPAirEnum,
	SmbPEnum,
	SmbPddfacIceEnum,
	SmbPddfacSnowEnum,
	SmbPrecipitationEnum,
	SmbPrecipitationsAnomalyEnum,
	SmbPrecipitationsLgmEnum,
	SmbPrecipitationsPresentdayEnum,
	SmbPrecipitationsReconstructedEnum,
	SmbReEnum,
	SmbRefreezeEnum,
	SmbReiniEnum,
	SmbRunoffEnum,
   SmbRunoffSubstepEnum,
   SmbRunoffTransientEnum,
	SmbS0gcmEnum,
	SmbS0pEnum,
	SmbS0tEnum,
	SmbSizeiniEnum,
	SmbSmbCorrEnum,
	SmbSmbrefEnum,
	SmbTEnum,
	SmbTaEnum,
	SmbTeValueEnum,
	SmbTemperaturesAnomalyEnum,
	SmbTemperaturesLgmEnum,
	SmbTemperaturesPresentdayEnum,
	SmbTemperaturesReconstructedEnum,
	SmbTiniEnum,
	SmbTmeanEnum,
	SmbTzEnum,
	SmbVEnum,
	SmbVmeanEnum,
	SmbVzEnum,
	SmbWEnum,
	SmbWiniEnum,
	SmbZMaxEnum,
	SmbZMinEnum,
	SmbZTopEnum,
	SmbZYEnum,
	StrainRateeffectiveEnum,
	StrainRateparallelEnum,
	StrainRateperpendicularEnum,
	StrainRatexxEnum,
	StrainRatexyEnum,
	StrainRatexzEnum,
	StrainRateyyEnum,
	StrainRateyzEnum,
	StrainRatezzEnum,
	StressMaxPrincipalEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	SurfaceAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceCrevasseEnum,
	SurfaceEnum,
	SurfaceOldEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceObservationEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePDDEnum,
	TemperaturePicardEnum,
	TemperatureSEMICEnum,
	ThermalSpctemperatureEnum,
	ThicknessAbsGradientEnum,
	ThicknessAbsMisfitEnum,
	ThicknessAcrossGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessEnum,
	ThicknessOldEnum,
	ThicknessPositiveEnum,
	ThicknessResidualEnum,
	VelEnum,
	VxAverageEnum,
	VxEnum,
	VxMeshEnum,
	VxObsEnum,
	VyAverageEnum,
	VyEnum,
	VyMeshEnum,
	VyObsEnum,
	VzEnum,
	VzFSEnum,
	VzHOEnum,
	VzMeshEnum,
	VzSSAEnum,
	WaterColumnOldEnum,
	WatercolumnEnum,
	WaterfractionDrainageEnum,
	WaterfractionDrainageIntegratedEnum,
	WaterfractionEnum,
	WaterheightEnum,
	WeightsSurfaceObservationEnum,
	Outputdefinition1Enum,
	Outputdefinition10Enum,
	Outputdefinition11Enum,
	Outputdefinition12Enum,
	Outputdefinition13Enum,
	Outputdefinition14Enum,
	Outputdefinition15Enum,
	Outputdefinition16Enum,
	Outputdefinition17Enum,
	Outputdefinition18Enum,
	Outputdefinition19Enum,
	Outputdefinition20Enum,
	Outputdefinition21Enum,
	Outputdefinition22Enum,
	Outputdefinition23Enum,
	Outputdefinition24Enum,
	Outputdefinition25Enum,
	Outputdefinition26Enum,
	Outputdefinition27Enum,
	Outputdefinition28Enum,
	Outputdefinition29Enum,
	Outputdefinition2Enum,
	Outputdefinition30Enum,
	Outputdefinition31Enum,
	Outputdefinition32Enum,
	Outputdefinition33Enum,
	Outputdefinition34Enum,
	Outputdefinition35Enum,
	Outputdefinition36Enum,
	Outputdefinition37Enum,
	Outputdefinition38Enum,
	Outputdefinition39Enum,
	Outputdefinition3Enum,
	Outputdefinition40Enum,
	Outputdefinition41Enum,
	Outputdefinition42Enum,
	Outputdefinition43Enum,
	Outputdefinition44Enum,
	Outputdefinition45Enum,
	Outputdefinition46Enum,
	Outputdefinition47Enum,
	Outputdefinition48Enum,
	Outputdefinition49Enum,
	Outputdefinition4Enum,
	Outputdefinition50Enum,
	Outputdefinition51Enum,
	Outputdefinition52Enum,
	Outputdefinition53Enum,
	Outputdefinition54Enum,
	Outputdefinition55Enum,
	Outputdefinition56Enum,
	Outputdefinition57Enum,
	Outputdefinition58Enum,
	Outputdefinition59Enum,
	Outputdefinition5Enum,
	Outputdefinition60Enum,
	Outputdefinition61Enum,
	Outputdefinition62Enum,
	Outputdefinition63Enum,
	Outputdefinition64Enum,
	Outputdefinition65Enum,
	Outputdefinition66Enum,
	Outputdefinition67Enum,
	Outputdefinition68Enum,
	Outputdefinition69Enum,
	Outputdefinition6Enum,
	Outputdefinition70Enum,
	Outputdefinition71Enum,
	Outputdefinition72Enum,
	Outputdefinition73Enum,
	Outputdefinition74Enum,
	Outputdefinition75Enum,
	Outputdefinition76Enum,
	Outputdefinition77Enum,
	Outputdefinition78Enum,
	Outputdefinition79Enum,
	Outputdefinition7Enum,
	Outputdefinition80Enum,
	Outputdefinition81Enum,
	Outputdefinition82Enum,
	Outputdefinition83Enum,
	Outputdefinition84Enum,
	Outputdefinition85Enum,
	Outputdefinition86Enum,
	Outputdefinition87Enum,
	Outputdefinition88Enum,
	Outputdefinition89Enum,
	Outputdefinition8Enum,
	Outputdefinition90Enum,
	Outputdefinition91Enum,
	Outputdefinition92Enum,
	Outputdefinition93Enum,
	Outputdefinition94Enum,
	Outputdefinition95Enum,
	Outputdefinition96Enum,
	Outputdefinition97Enum,
	Outputdefinition98Enum,
	Outputdefinition99Enum,
	Outputdefinition9Enum,
	Outputdefinition100Enum,
	/*}}}*/
	InputsENDEnum,
	/*Other{{{*/
	AbsoluteEnum,
	AdaptiveTimesteppingEnum,
	AdjointBalancethickness2AnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AggressiveMigrationEnum,
	AmrBamgEnum,
	AmrNeopzEnum,
	AndroidFrictionCoefficientEnum,
	ArrheniusEnum,
	AutodiffJacobianEnum,
	Balancethickness2AnalysisEnum,
	Balancethickness2SolutionEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessApparentMassbalanceEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancethicknessSolutionEnum,
	BalancethicknessSpcthicknessEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	BasalforcingsIsmip6Enum,
	BasalforcingsPicoEnum,
	BeckmannGoosseFloatingMeltRateEnum,
	BedSlopeSolutionEnum,
	BoolExternalResultEnum,
	BoolInputEnum,
	BoolInput2Enum,
	IntInput2Enum,
	BoolParamEnum,
	BoundaryEnum,
	BuddJackaEnum,
	CalvingDev2Enum,
	CalvingHabEnum,
	CalvingLevermannEnum,
	CalvingVonmisesEnum,
	CfdragcoeffabsgradEnum,
	CfsurfacelogvelEnum,
	CfsurfacesquareEnum,
	ChannelEnum,
	ChannelAreaEnum,
	ChannelAreaOldEnum,
	ClosedEnum,
	ColinearEnum,
	ConstraintsEnum,
	ContactEnum,
	ContourEnum,
	ContoursEnum,
	ControlInputEnum,
	ControlInput2Enum,
	ControlInputGradEnum,
	ControlInputMaxsEnum,
	ControlInputMinsEnum,
	ControlInputValuesEnum,
	CrouzeixRaviartEnum,
	CuffeyEnum,
	CuffeyTemperateEnum,
	DamageEvolutionAnalysisEnum,
	DamageEvolutionSolutionEnum,
	DataSetEnum,
	DataSetParamEnum,
	DatasetInputEnum,
	DatasetInput2Enum,
	DefaultAnalysisEnum,
	DefaultCalvingEnum,
	DenseEnum,
	DependentObjectEnum,
	DepthAverageAnalysisEnum,
	DeviatoricStressErrorEstimatorEnum,
	DivergenceEnum,
	Domain3DsurfaceEnum,
	DoubleArrayInputEnum,
	ArrayInput2Enum,
	DoubleExternalResultEnum,
	DoubleInputEnum,
	DoubleMatArrayParamEnum,
	DoubleMatExternalResultEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementHookEnum,
	ElementSIdEnum,
	EnthalpyAnalysisEnum,
	EsaAnalysisEnum,
	EsaSolutionEnum,
	EsaTransitionsEnum,
	ExternalResultEnum,
	ExtrapolationAnalysisEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	FSApproximationEnum,
	FSSolverEnum,
	FSpressureEnum,
	FSvelocityEnum,
	FemModelEnum,
	FileParamEnum,
	FixedTimesteppingEnum,
	FloatingAreaEnum,
	FloatingAreaScaledEnum,
	FloatingMeltRateEnum,
	FreeEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	FrontalForcingsDefaultEnum,
	FrontalForcingsRignotEnum,
	FsetEnum,
	FullMeltOnPartiallyFloatingEnum,
	GLheightadvectionAnalysisEnum,
	GaussPentaEnum,
	GaussSegEnum,
	GaussTetraEnum,
	GaussTriaEnum,
	GenericOptionEnum,
	GenericParamEnum,
	GiaIvinsAnalysisEnum,
	GiaSolutionEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GroundedAreaEnum,
	GroundedAreaScaledEnum,
	GroundingOnlyEnum,
	GroundinglineMassFluxEnum,
	GsetEnum,
	GslEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	HookEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyGlaDSAnalysisEnum,
	HydrologyGlaDSEnum,
	HydrologyPismAnalysisEnum,
	HydrologyShaktiAnalysisEnum,
	HydrologyShreveAnalysisEnum,
	HydrologySolutionEnum,
	HydrologydcEnum,
	HydrologypismEnum,
	HydrologyshaktiEnum,
	HydrologyshreveEnum,
	IceMassEnum,
	IceMassScaledEnum,
	IceVolumeAboveFloatationEnum,
	IceVolumeAboveFloatationScaledEnum,
	IceVolumeEnum,
	IceVolumeScaledEnum,
	IcefrontMassFluxEnum,
	IcefrontMassFluxLevelsetEnum,
	IncrementalEnum,
	IndexedEnum,
	IntExternalResultEnum,
	IntInputEnum,
	ElementInput2Enum,
	SegInput2Enum,
	TriaInput2Enum,
	PentaInput2Enum,
	IntMatExternalResultEnum,
	IntMatParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	Inputs2Enum,
	InternalEnum,
	IntersectEnum,
	InversionVzObsEnum,
	JEnum,
	L1L2ApproximationEnum,
	L2ProjectionBaseAnalysisEnum,
	L2ProjectionEPLAnalysisEnum,
	LACrouzeixRaviartEnum,
	LATaylorHoodEnum,
	LambdaSEnum,
	LevelsetAnalysisEnum,
	LevelsetfunctionPicardEnum,
	LinearFloatingMeltRateEnum,
	LliboutryDuvalEnum,
	LoadsEnum,
	LoveAnalysisEnum,
	LoveHiEnum,
	LoveHrEnum,
	LoveKernelsImagEnum,
	LoveKernelsRealEnum,
	LoveKiEnum,
	LoveKrEnum,
	LoveLiEnum,
	LoveLrEnum,
	LoveSolutionEnum,
	MINIEnum,
	MINIcondensedEnum,
	MantlePlumeGeothermalFluxEnum,
	MassFluxEnum,
	MassconEnum,
	MassconaxpbyEnum,
	MassfluxatgateEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	MatdamageiceEnum,
	MatenhancediceEnum,
	MaterialsEnum,
	MatestarEnum,
	MaticeEnum,
	MatlithoEnum,
	MatrixParamEnum,
	MaxAbsVxEnum,
	MaxAbsVyEnum,
	MaxAbsVzEnum,
	MaxDivergenceEnum,
	MaxVelEnum,
	MaxVxEnum,
	MaxVyEnum,
	MaxVzEnum,
	MelangeEnum,
	MeltingAnalysisEnum,
	MeshElementsEnum,
	MeshXEnum,
	MeshYEnum,
	MinVelEnum,
	MinVxEnum,
	MinVyEnum,
	MinVzEnum,
	MismipFloatingMeltRateEnum,
	MoulinEnum,
	MpiDenseEnum,
	MpiEnum,
	MpiSparseEnum,
	MumpsEnum,
	NoFrictionOnPartiallyFloatingEnum,
	NoMeltOnPartiallyFloatingEnum,
	NodalEnum,
	NodalvalueEnum,
	NodeSIdEnum,
	NoneApproximationEnum,
	NoneEnum,
	NumberedcostfunctionEnum,
	NyeCO2Enum,
	NyeH2OEnum,
	NumericalfluxEnum,
	OldGradientEnum,
	OneLayerP4zEnum,
	OpenEnum,
	OptionEnum,
	ParamEnum,
	ParametersEnum,
	P0ArrayEnum,
	P0DGEnum,
	P1DGEnum,
	P1P1Enum,
	P1P1GLSEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P1xP2Enum,
	P1xP3Enum,
	P1xP4Enum,
	P2Enum,
	P2bubbleEnum,
	P2bubblecondensedEnum,
	P2xP1Enum,
	P2xP4Enum,
	PatersonEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaInputEnum,
	ProfilerEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingCurrentMemEnum,
	ProfilingSolutionTimeEnum,
	RegionaloutputEnum,
	RegularEnum,
	RecoveryAnalysisEnum,
	RiftfrontEnum,
	SIAApproximationEnum,
	SMBcomponentsEnum,
	SMBd18opddEnum,
	SMBforcingEnum,
	SMBgcmEnum,
	SMBgembEnum,
	SMBgradientsEnum,
	SMBgradientscomponentsEnum,
	SMBgradientselaEnum,
	SMBhenningEnum,
	SMBmeltcomponentsEnum,
	SMBpddEnum,
	SMBpddSicopolisEnum,
	SMBsemicEnum,
	SSAApproximationEnum,
	SSAFSApproximationEnum,
	SSAHOApproximationEnum,
	ScaledEnum,
	SealevelAbsoluteEnum,
	SealevelEmotionEnum,
	SealevelInertiaTensorXZEnum,
	SealevelInertiaTensorYZEnum,
	SealevelInertiaTensorZZEnum,
	SealevelNmotionEnum,
	SealevelUmotionEnum,
	SealevelriseAnalysisEnum,
	SealevelriseSolutionEnum,
	SegEnum,
	SegInputEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SeparateEnum,
	SeqEnum,
	SmbAnalysisEnum,
	SmbSolutionEnum,
	SmoothAnalysisEnum,
	SoftMigrationEnum,
	SpatialLinearFloatingMeltRateEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	SsetEnum,
	SteadystateSolutionEnum,
	StressIntensityFactorEnum,
	StressbalanceAnalysisEnum,
	StressbalanceConvergenceNumStepsEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	StringArrayParamEnum,
	StringExternalResultEnum,
	StringParamEnum,
	SubelementFriction1Enum,
	SubelementFriction2Enum,
	SubelementMelt1Enum,
	SubelementMelt2Enum,
	SubelementMigrationEnum,
	SurfaceSlopeSolutionEnum,
	TaylorHoodEnum,
	TetraEnum,
	TetraInputEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	ThicknessErrorEstimatorEnum,
	TotalCalvingFluxLevelsetEnum,
	TotalCalvingMeltingFluxLevelsetEnum,
	TotalFloatingBmbEnum,
	TotalFloatingBmbScaledEnum,
	TotalGroundedBmbEnum,
	TotalGroundedBmbScaledEnum,
	TotalSmbEnum,
	TotalSmbScaledEnum,
	TransientArrayParamEnum,
	TransientInputEnum,
	TransientInput2Enum,
	TransientParamEnum,
	TransientSolutionEnum,
	TriaEnum,
	TriaInputEnum,
	UzawaPressureAnalysisEnum,
	VectorParamEnum,
	VertexEnum,
	VertexLIdEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	VerticesEnum,
	ViscousHeatingEnum,
	WaterEnum,
	XTaylorHoodEnum,
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Unused?{{{*/
	BalancethicknessD0Enum,
	BalancethicknessDiffusionCoefficientEnum,
	BilinearInterpEnum,
	CalvingdevCoeffEnum,
	DeviatoricStressEnum,
	EtaAbsGradientEnum,
	MeshZEnum,
	NearestInterpEnum,
	OutputdefinitionListEnum,
	SealevelObsEnum,
	SealevelWeightsEnum,
	StrainRateEnum,
	StressTensorEnum,
	StressbalanceViscosityOvershootEnum,
	SubelementMigration4Enum,
	TimesteppingTimeAdaptEnum,
	TriangleInterpEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
