#!/bin/bash
#set -eu # Do not `run set -eu` because it causes some targets to fail


# NOTE:
# - Stop after bootstrap step and run `b2 --debug-configuration` to figure
#	out which paths Boost is using to include Python. Make sure that each of
#	the listed paths is covered by Python. If not, you must create a symbolic
#	link from $ISSM_DIR/externalpackages/python to the location of the file
#	that Boost is expecting. There is no way to get the Boost to compile with
#	Python otherwise.
#

## Constants
#
VER="1_72_0"

## Envrionment
#
#export CXXFLAGS='-std=c++98' # Setting CXXFLAGS to deal with C++11 incompatibility with Matlab's Boost
#export CXXFLAGS='-std=c++11'

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/boost_${VER}.tar.gz" "boost_${VER}.tar.gz"

# Unpack source
tar -zxvf boost_${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source into 'src' directory
mv boost_${VER}/* src/
rm -rf boost_${VER}

# Configure
cd src
./bootstrap.sh \
	--prefix="${ISSM_DIR}/externalpackages/boost/install" \
	--with-python=python2.7 \
	--with-python-root="${ISSM_DIR}/externalpackages/python/install"

# Modify project config to enable MPI
printf "\n# Enable MPI\nusing mpi ;\n" >> project-config.jam

# Compile and install
./b2 --toolset=gcc install
