#!/bin/bash
#set -eu # Do not `run set -eu` because it causes some targets to fail


# NOTE:
# - Stop after bootstrap step and run `bjam --debug-configuration` to figure
#	out which paths Boost is using to include Python. Make sure that each of
#	the listed paths is covered by Python. If not, you must create a symbolic
#	link from $ISSM_DIR/externalpackages/python to the location of the file
#	that Boost is expecting. There is no way to get the Boost to compile with
#	Python otherwise.
#

## Constants
#
VER="1_55_0"

## Evnrionment
#
export CXXFLAGS='-std=c++98' # Setting CXXFLAGS to deal with C++11 incompatibility with Matlab's Boost

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/boost_${VER}.tar.gz" "boost_${VER}.tar.gz"

# Unpack source
tar -zxvf boost_${VER}.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source into 'src' directory
mv boost_${VER}/* src/
rm -rf boost_${VER}

# Copy customized source and configuration files to 'src' driectory
cp configs/1.55/linux/boost/multi_index/ordered_index.hpp src/boost/multi_index

# Configure
cd src
./bootstrap.sh \
	--prefix="${ISSM_DIR}/externalpackages/boost/install" \
	--with-python=python2.7 \
	--with-python-root="${ISSM_DIR}/externalpackages/python/install"

# Modify project config to enable MPI
printf "\n# Enable MPI\nusing mpi ;\n" >> project-config.jam

# Compile and install
./bjam link=static install

# Copy binary to install directory
mkdir ../install/bin
cp bjam ../install/bin
