#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.12.3 src
mkdir install src

#Download from ISSM server
#$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.12.3.tar.gz' 'petsc-3.12.3.tar.gz'
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'http://ftp.mcs.anl.gov/pub/petsc/release-snapshots/petsc-lite-3.12.3.tar.gz' 'petsc-3.12.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.12.3.tar.gz
mv petsc-3.12.3/* src/
rm -rf petsc-3.12.3

#configure (based on /nasa/petsc/3.7.5/intel_mpt/lib/petsc/conf/petscvariables look for CONFIGURE_OPTIONS)
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-cc=icc --with-cxx=icpc --with-fc=ifort --with-f77=ifort --with-gnu-compilers=0 --with-cpp=/usr/bin/cpp \
	--with-vendor-compilers=intel \
	-COPTFLAGS=-g -O3 -axCORE-AVX2,AVX -xSSE4.2 -CXXOPTFLAGS=-g -O3 -axCORE-AVX2,AVX -xSSE4.2 -FOPTFLAGS=-g -O3 -axCORE-AVX2,AVX -xSSE4.2 \
	--with-blas-lapack-dir=/nasa/intel/Compiler/2016.2.181/mkl/lib/intel64 \
	--with-scalapack-include=/nasa/intel/Compiler/2016.2.181/mkl/include \
	--with-scalapack-lib="/nasa/intel/Compiler/2016.2.181/mkl/lib/intel64/libmkl_scalapack_lp64.so /nasa/intel/Compiler/2016.2.181/mkl/lib/intel64/libmkl_blacs_sgimpt_lp64.so" \
	--with-shared-libraries=1 \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 

#  --download-superlu_dist=yes \
#	--download-hypre=yes

#prepare script to reconfigure petsc
cat > script.queue << EOF
#PBS -S /bin/bash
#PBS -l select=1:ncpus=1:model=bro
#PBS -l walltime=200 
#PBS -W group_list=s1690
#PBS -m e 

. /usr/share/modules/init/bash 
module load pkgsrc
module load comp-intel/2016.2.181
module load mpi-sgi/mpt

export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== qsub -q devel script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
