import os
import socket
import platform
from loadresultsfromdisk import loadresultsfromdisk
from helpers import *


def loadresultsfromcluster(md, runtimename=False):
    """
    LOADRESULTSFROMCLUSTER - load results of solution sequence from cluster

       Usage:
          md = loadresultsfromcluster(md, runtimename)
    """

    #retrieve cluster, to be able to call its methods
    cluster = md.cluster

    if runtimename:
        md.private.runtimename = runtimename

    #Download outputs from the cluster
    filelist = [md.miscellaneous.name + '.outlog', md.miscellaneous.name + '.errlog']
    if md.qmu.isdakota:
        filelist.append(md.miscellaneous.name + '.qmu.err')
        filelist.append(md.miscellaneous.name + '.qmu.out')
        if 'tabular_graphics_data' in fieldnames(md.qmu.params):
            if md.qmu.params.tabular_graphics_data:
                filelist.append('dakota_tabular.dat')
    else:
        filelist.append(md.miscellaneous.name + '.outbin')
    cluster.Download(md.private.runtimename, filelist)

    #If we are here, no errors in the solution sequence, call loadresultsfromdisk.
    if os.path.exists(md.miscellaneous.name + '.outbin'):
        if os.path.getsize(md.miscellaneous.name + '.outbin') > 0:
            md = loadresultsfromdisk(md, md.miscellaneous.name + '.outbin')
        else:
            print(('WARNING, outbin file is empty for run ' + md.miscellaneous.name))
    elif not md.qmu.isdakota:
        print(('WARNING, outbin file does not exist ' + md.miscellaneous.name))

    #erase the log and output files
    if md.qmu.isdakota:
        #filename = os.path.join('qmu' + str(os.getpid()), md.miscellaneous.name)
        filename = md.miscellaneous.name

        # this will not work like normal as dakota doesn't generate outbin files,
        #   instead calls postqmu to store results directly in the model
        #   at md.results.dakota via dakota_out_parse
        md = loadresultsfromdisk(md, md.miscellaneous.name + '.outbin')
    else:
        filename = md.miscellaneous.name
        TryRem('.outbin', filename)
        if not platform.system() == 'Windows':
            TryRem('.tar.gz', md.private.runtimename)

    TryRem('.errlog', filename)
    TryRem('.outlog', filename)

    #erase input file if run was carried out on same platform.
    hostname = socket.gethostname()
    if hostname == cluster.name:
        if md.qmu.isdakota:
            #filename = os.path.join('qmu' + str(os.getpid()), md.miscellaneous.name)
            filename = md.miscellaneous.name
            TryRem('.queue', filename)
        else:
            filename = md.miscellaneous.name
            TryRem('.toolkits', filename)
            if not platform.system() == 'Windows':
                TryRem('.queue', filename)
            else:
                TryRem('.bat', filename)

    # remove this for bin file debugging
        TryRem('.bin', filename)

    return md

def TryRem(extension, filename):
    try:
        os.remove(filename + extension)
    except OSError:
        print(('WARNING, no ' + extension + '  is present for run ' + filename))
