import numpy as np
from fielddisplay import fielddisplay
from checkfield import checkfield
from WriteData import WriteData
from project3d import project3d


class dsl(object):
    """
    dsl Class definition

       Usage:
          dsl = dsl()
    """

    def __init__(self):  # {{{
        self.lobal_average_thermosteric_sea_level_change = float('NaN') #corresponds to zostoga field in CMIP5 archives. Specified as a temporally variable global rate (mm/yr)
        self.sea_surface_height_change_above_geoid = float('NaN') #corresponds to zos field in CMIP5 archives. Spatial average is 0. Specified as a spatio-temporally variable rate (mm/yr)
        self.sea_water_pressure_change_at_sea_floor = float('NaN') #corresponds to bpo field in CMIP5 archives. Specified as a spatio-temporally variable rate (in Pa/yr)
    #}}}

    def __repr__(self):  # {{{
        string = "   dsl parameters:"
        string = "%s\n%s" % (string, fielddisplay(self,'global_average_thermosteric_sea_level_change','corresponds to zostoga field in CMIP5 archives. Specified as a temporally variable global rate (mm/yr)'))
        string = "%s\n%s" % (string, fielddisplay(self,'sea_surface_height_change_above_geoid','corresponds to zos field in CMIP5 archives. Spatial average is 0. Specified as a spatio-temporally variable rate (mm/yr)'))
        string = "%s\n%s" % (string, fielddisplay(self,'sea_water_pressure_change_at_sea_floor','corresponds to bpo field in CMIP5 archives. Specified as a spatio-temporally variable rate (in Pa/yr)'))

        return string
    #}}}

    def extrude(self, md):  # {{{

        self.sea_surface_height_change_above_geoid = project3d(md, 'vector', self.sea_surface_height_change_above_geoid, 'type', 'node')
        self.sea_water_pressure_change_at_sea_floor = project3d(md, 'vector', self.sea_water_pressure_change_at_sea_floor, 'type', 'node')
        return self
    #}}}

    def defaultoutputs(self, md):  # {{{
        return []
    #}}}

    def checkconsistency(self, md, solution, analyses):  # {{{
        if 'SealevelriseAnalysis' in analyses:
            md = checkfield(md, 'fieldname', 'dsl.sea_surface_height_change_above_geoid', 'timeseries', 1, 'NaN', 1, 'Inf', 1)
            md = checkfield(md, 'fieldname', 'dsl.sea_water_pressure_change_at_sea_floor', 'timeseries', 1, 'NaN', 1, 'Inf', 1)
        return md
    # }}}

    def marshall(self, prefix, md, fid):    # {{{
        yts = md.constants.yts
        WriteData(fid, prefix, 'name', 'md.dsl.model', 'data', 1, 'format', 'Integer')
        WriteData(fid,prefix,'object',self,'class','dsl','fieldname','global_average_thermosteric_sea_level_change','format','DoubleMat','mattype',1,'timeserieslength',1+1,'yts',md.constants.yts,'scale',1e-3/md.constants.yts)
			WriteData(fid,prefix,'object',self,'class','dsl','fieldname','sea_water_pressure_change_at_sea_floor','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts,'scale',1e-3/md.constants.yts)
			WriteData(fid,prefix,'object',self,'class','dsl','fieldname','sea_surface_height_change_above_geoid','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts)
    # }}}
