#!/bin/bash
set -eu


## Constants
#
VER="3.3"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/mpich-${VER}.tar.gz" "mpich-${VER}.tar.gz"

# Unpack source
tar -zxvf  mpich-$VER.tar.gz

# Cleanup
rm -rf src install
mkdir src install

# Move source into 'src' directory
mv mpich-$VER/* src
rm -rf mpich-$VER

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/mpich/install" \
	--enable-shared

# Compile and install
make
make install

# Return to initial directory
cd ..
