/*! \file DatasetInput2.h 
 *  \brief: header file for datasetinput object
 */

#ifndef _DATASETINPUT2_H_
#define _DATASETINPUT2_H_

/*Headers:*/
#include "./Input2.h"
class TriaInput2;
class PentaInput2;
class TransientInput2;

class DatasetInput2: public Input2{

	private:
		int             numids;
		Input2        **inputs;
		int            *ids;
		int             numberofelements_local;
		int             numberofvertices_local;
		
	public:
		int GetNumIds() const {return this->numids;};
		/*DatasetInput constructors, destructors: {{{*/
		DatasetInput2();
		DatasetInput2(int nbe, int nbv);
		~DatasetInput2();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		Input2* copy();
		void    Configure(Parameters* params);
		void    DeepEcho();
		void    Echo();
		int     Id();
		void    Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int     ObjectEnum();
		void    SetTriaInput(int interp_in,int numinds,int* rows,IssmDouble* values_in);
		/*}}}*/
		void SetTriaInput(int id,int interp_in,int numinds,int* rows,IssmDouble* values_in);
		void SetPentaInput(int id,int interp_in,int numinds,int* rows,IssmDouble* values_in);
		TransientInput2* SetTransientInput(int id,IssmDouble* times,int numtimes);
		PentaInput2* GetPentaInputByOffset(int i);
		TriaInput2*  GetTriaInputByOffset(int i);
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss,int index);
};
#endif  /* _DATASETINPUT2_H */
