#!/bin/bash
set -eu


# Constants
#
VER="6.2"

# Cleanup
rm -rf Dakota
rm -rf src
rm -rf build
rm -rf install
mkdir src build install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/dakota-${VER}-public.src.tar.gz" "dakota-${VER}-public-src.tar.gz"

#Untar
tar -zxvf dakota-${VER}-public-src.tar.gz

#Move Dakota to src directory
mv dakota-${VER}.0.src/* src
rm -rf dakota-${VER}.0.src

#Set up Dakota cmake variables and config
DAK_PATH=$ISSM_DIR/externalpackages/dakota

export DAK_BUILD=$DAK_PATH/build
export DAK_INSTALL=$DAK_PATH/install
export DAK_SRC=$DAK_PATH/src
export MPIHOME=$ISSM_DIR/externalpackages/mpich/install
export BOOST_ROOT=$ISSM_DIR/externalpackages/boost/install
export BLAS_LIBS="-L${ISSM_DIR}/externalpackages/lapack/install/lib -lblas" # Need to export BLAS_LIBS *and* pass is as an option to CMake to ensure that external packages also find it
export LAPACK_LIBS="-L${ISSM_DIR}/externalpackages/lapack/install/lib -llapack" # Need to export BLAS_LIBS *and* pass is as an option to CMake to ensure thatss is as an option to CMake to ensure that external packages also find it


cp $DAK_SRC/cmake/BuildDakotaTemplate.cmake $DAK_SRC/cmake/BuildDakotaCustom.cmake
patch $DAK_SRC/cmake/BuildDakotaCustom.cmake configs/${VER}/BuildDakotaCustom.cmake.patch
patch $DAK_SRC/cmake/DakotaDev.cmake configs/${VER}/DakotaDev.cmake.patch
patch $DAK_SRC/CMakeLists.txt configs/6.2/CMakeLists.txt.petsclibs.patch

#Apply patches
patch src/src/NonDSampling.cpp configs/${VER}/NonDSampling.cpp.patch
patch src/src/NonDLocalReliability.cpp configs/${VER}/NonDLocalReliability.cpp.patch
patch src/packages/pecos/src/pecos_global_defs.hpp configs/${VER}/pecos_global_defs.hpp.patch

#Setting CXXFLAGS to deal with C++11 incompatibility with Matlab's Boost
export CXXFLAGS='-std=c++98'

#Configure dakota
cd $DAK_BUILD

cmake \
	-DBUILD_STATIC_LIBS=ON \
	-DBUILD_SHARED_LIBS=OFF \
	-DBoost_INSTALL_PREFIX=$DAK_INSTALL \
	-DBOOST_ROOT=$BOOST_ROOT \
	-DBoost_NO_BOOST_CMAKE=TRUE \
	-DBoost_LIBRARY_DIRS=$BOOST_ROOT/lib \
	-DBoost_NO_SYSTEM_PATHS=TRUE \
	-DCMAKE_C_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicc \
	-DCMAKE_CXX_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicxx \
	-DCMAKE_Fortran_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpif77 \
	-DCMAKE_C_FLAGS="-O2 -g -fPIC" \
	-DCMAKE_CXX_FLAGS="-O2 -g -fPIC" \
	-DCMAKE_Fortran_FLAGS="-O2 -g -fPIC" \
	-DHAVE_ACRO=off \
	-DHAVE_JEGA=off \
	-C$DAK_SRC/cmake/BuildDakotaCustom.cmake \
	-C$DAK_SRC/cmake/DakotaDev.cmake \
	$DAK_SRC

cd ..

#Compile and install dakota
cd $DAK_BUILD

if [ $# -eq 0 ];
then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

cd ..
