/*!\file InputUpdateFromConstantx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromConstantx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../classes/Inputs2/Inputs2.h"

void InputUpdateFromConstantx(FemModel* femmodel,bool constant, int name){
	if(VerboseModule()) _printf0_("   Input updates from constant\n");

	/*Elements and loads drive the update: */
	for(int i=0;i<femmodel->elements->Size();i++){
		Element* element=xDynamicCast<Element*>(femmodel->elements->GetObjectByOffset(i));
		element->InputUpdateFromConstant(constant,name);
	}
}
void InputUpdateFromConstantx(FemModel* femmodel,int constant, int name){

	if(VerboseModule()) _printf0_("   Input updates from constant\n");

	/*Elements and loads drive the update: */
	for(int i=0;i<femmodel->elements->Size();i++){
		Element* element=xDynamicCast<Element*>(femmodel->elements->GetObjectByOffset(i));
		element->InputUpdateFromConstant(constant,name);
	}
}
void InputUpdateFromConstantx(FemModel* femmodel,IssmDouble constant, int name){

	if(VerboseModule()) _printf0_("   Input updates from constant\n");

	/*Elements and loads drive the update: */
	if(IsInputEnum(name)){
		for(int i=0;i<femmodel->elements->Size();i++){
			Element* element=xDynamicCast<Element*>(femmodel->elements->GetObjectByOffset(i));
			element->InputUpdateFromConstant(constant,name);
		}
	}
	else if(IsParamEnum(name)){
		if(femmodel->parameters->Exist(name)){
			femmodel->parameters->SetParam(constant,name);
		}
		else{
			_error_("Param not set");
		}
	}
	else{
		_error_("not supported");
	}
}
void InputUpdateFromConstantx(Inputs2* inputs2,Elements* elements,IssmDouble constant, int name){

	if(VerboseModule()) _printf0_("   Input updates from constant\n");

	/*Elements and loads drive the update: */
	for(int i=0;i<elements->Size();i++){
		Element* element=xDynamicCast<Element*>(elements->GetObjectByOffset(i));
		element->SetElementInput(inputs2,name,constant);
	}
}
void InputUpdateFromConstantx(Inputs2* inputs2,Elements* elements,bool constant, int name){

	if(VerboseModule()) _printf0_("   Input updates from constant\n");

	/*Elements and loads drive the update: */
	for(int i=0;i<elements->Size();i++){
		Element* element=xDynamicCast<Element*>(elements->GetObjectByOffset(i));
		element->SetBoolInput(inputs2,name,constant);
	}
}
