/*! \file ControlInput2.h 
 *  \brief: header file for triavertexinput object
 */

#ifndef _CONTROLINPUT2_H_
#define _CONTROLINPUT2_H_

/*Headers:*/
#include "./Input2.h"
class Gauss;
class ElementInput2;

class ControlInput2: public Input2{

	public:
		int            control_id;
		int            enum_type;
		int            layout_enum;
		ElementInput2 *gradient;
		ElementInput2 *maxvalues;
		ElementInput2 *minvalues;
		ElementInput2 *savedvalues;
		ElementInput2 *values;

		/*ControlInput2 constructors, destructors: {{{*/
		ControlInput2();
		ControlInput2(int nbe, int nbv,int input_layout_enum,int interp,int id);
		~ControlInput2();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		Input2* copy();
		void    DeepEcho();
		void    Echo();
		int     Id(); 
		void    Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int     ObjectEnum();
		/*}}}*/
		void SetInput(Input2* in_input){_error_("not impelemented");};
		void SetInput(Input2* in_input,int timeoffset){_error_("not impelemented");};
		ElementInput2* GetInput2(const char* data);
		void SetControl(int interp,int numindices,int* indices,IssmDouble* values_in,IssmDouble* values_min,IssmDouble* values_max);
		void SetGradient(int interp,int numindices,int* indices,IssmDouble* values_in);
		void SetGradient(int interp,int numindices,int* indices,IssmDouble* values_in,int n);
		TriaInput2* GetTriaInput();
		PentaInput2* GetPentaInput();
};
#endif  /* _CONTROLINPUT_H */
