/*!\file ArrayInput2.c
 * \brief: implementation of the ArrayInput2 object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
#include "./ArrayInput2.h"

/*ArrayInput2 constructors and destructor*/
ArrayInput2::ArrayInput2(void){/*{{{*/

	this->numberofelements_local = -1;
	this->N                      = -1;
	this->values                 = NULL;

}/*}}}*/
ArrayInput2::ArrayInput2(int nbe_in,int N_in){/*{{{*/

	_assert_(nbe_in>0);
	_assert_(nbe_in<1e11);
	this->numberofelements_local = nbe_in;
	this->N                      = N_in;
	this->values                 = xNewZeroInit<IssmDouble>(this->numberofelements_local*this->N);

}/*}}}*/
ArrayInput2::~ArrayInput2(){/*{{{*/
	if(this->values) xDelete<IssmDouble>(this->values);
}
/*}}}*/

/*Object virtual functions definitions:*/
Input2* ArrayInput2::copy() {/*{{{*/

	ArrayInput2* output = new ArrayInput2(this->numberofelements_local,this->N);
	xMemCpy<IssmDouble>(output->values,this->values,this->numberofelements_local*this->N);

	return output;
}
/*}}}*/
void ArrayInput2::DeepEcho(void){/*{{{*/
	_printf_("ArrayInput2 Echo:\n");
	_printf_("   Size:          "<<N<<"\n");
	//printarray(this->values,this->M,this->N);
	//_printf_(setw(15)<<"   ArrayInput2 "<<setw(25)<<left<<EnumToStringx(this->enum_type)<<" "<<(value?"true":"false") << "\n");
}
/*}}}*/
void ArrayInput2::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
int  ArrayInput2::Id(void){/*{{{*/
	return -1;
}/*}}}*/
void ArrayInput2::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(ArrayInput2Enum);
	MARSHALLING(this->numberofelements_local);
	MARSHALLING(this->N);
	if(this->numberofelements_local*this->N){
		MARSHALLING_DYNAMIC(this->values,IssmDouble,this->numberofelements_local*this->N);
	}
	else this->values = NULL;

}
/*}}}*/
int  ArrayInput2::ObjectEnum(void){/*{{{*/
	return ArrayInput2Enum;
}
/*}}}*/

/*ArrayInput2 management*/
void ArrayInput2::SetInput(int row,int numindices,IssmDouble* values_in){/*{{{*/

	_assert_(this);
	_assert_(this->N==numindices);
	for(int i=0;i<numindices;i++) this->values[row*this->N+i] = values_in[i];
}
/*}}}*/
