/*! \file TransientInput2.h
 *  \brief: header file for transientinput object
 */

#ifndef _TRANSIENTINPUT2_H_
#define _TRANSIENTINPUT2_H_

/*Headers:*/
#include "./Input2.h"
class Gauss;
class Parameters;

class TransientInput2: public Input2{

	private:
		int     numberofelements_local;
		int     numberofvertices_local;

	public:
		int         enum_type;
		int         numtimesteps;
		Input2**    inputs;
		IssmDouble *timesteps;
		Parameters *parameters;     //to find current time.

		IssmDouble  current_step;
		Input2*     current_input;

		/*TransientInput2 constructors, destructors: {{{*/
		TransientInput2();
		TransientInput2(int in_enum_type,int nbe,int nbv,IssmDouble* times,int N);
		~TransientInput2();
		void AddTimeInput(Input2* input,IssmDouble time);
		void AddTriaTimeInput(int step,int numindices,int* indices,IssmDouble* values_in,int interp_in);
		void AddPentaTimeInput(int step,int numindices,int* indices,IssmDouble* values_in,int interp_in);
		/*}}}*/
		/*Object virtual functions definitions:{{{*/
		Input2* copy();
		void    Configure(Parameters* params);
		void    DeepEcho();
		void    Echo();
		int     Id();
		void    Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int     ObjectEnum();
		/*}}}*/
		/*TransientInput2 management:*/
		TriaInput2*  GetTriaInput();
		TriaInput2*  GetTriaInput(IssmDouble time);
		PentaInput2* GetPentaInput();
		PentaInput2* GetPentaInput(IssmDouble time);
		Input2*      GetTimeInput(IssmDouble time){_error_("This should not happen!");};
		IssmDouble   GetTimeByOffset(int offset);
		int          GetTimeInputOffset(IssmDouble time);
		void         SetCurrentTimeInput(IssmDouble time);
		/*numerics:*/

};
#endif  /* _TRANSIENTINPUT_H */
