#!/bin/bash
set -eu


## Constants
#
VER="6.0.0"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/gmt-${VER}.tar.gz" "gmt-${VER}.tar.gz"

# Unpack source
tar -zxvf gmt-$VER.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv gmt-$VER/* src
rm -rf gmt-$VER

# Copy custom configuration files
cp ./configs/Linux/cmake/ConfigUser.cmake ./src/cmake

# Configure
cd src
mkdir build
cd build
cmake ..

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

# Return to initial directory
cd ../..
