#!/bin/bash
set -eu


## Constants
#
VER="3.11.3"

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/petsc-lite-${VER}.tar.gz" "petsc-${VER}.tar.gz"

# Unpack source
tar -zxvf  petsc-$VER.tar.gz

# Cleanup
rm -rf install src
mkdir install src

# Move source to 'src' directory
mv petsc-$VER/* src/
rm -rf petsc-$VER

# Configure
cd src
./config/configure.py \
	--prefix="${ISSM_DIR}/externalpackages/petsc/install" \
	--PETSC_DIR="${ISSM_DIR}/externalpackages/petsc/src" \
	--with-mpi-dir="${ISSM_DIR}/externalpackages/mpich/install" \
	--with-blas-lib="-L${ISSM_DIR}/externalpackages/lapack/install/lib -lblas" \
	--with-lapack-lib="-L${ISSM_DIR}/externalpackages/lapack/install/lib -llapack" \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-shared-libraries=1 \
	--download-zlib=1\
	--download-hdf5=1 \
	--download-netcdf=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-scalapack=1 \
	--download-mumps=1

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

# Return to initial directory
cd ..
