#!/bin/bash
set -eu


## TODO
#	- May want to supply path to Python instead of, effectively, using result of `which python`
#

## Constants
#
VER="3.0.2"
PROJ_ROOT="${ISSM_DIR}/externalpackages/proj/install"

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "http://issm.jpl.nasa.gov/files/externalpackages/gdal-${VER}.tar.gz" "gdal-${VER}.tar.gz"

# Unpack source
tar -zxvf gdal-$VER.tar.gz

# Move source into 'src' directory
mv gdal-$VER/* src
rm -rf gdal-$VER

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/gdal/install" \
	--with-python \
	--with-proj="${PROJ_ROOT}"

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
