#!/bin/bash
set -eu


# TODO:
# - Introduce build step to $ISSM_DIR/jenkins/jenkins.sh to compile Fortran code in $ISSM_DIR/src/c/modules/GiaDefelectionCorex/ to C with f2c
#	- Then, revert $ISSM_DIR/externalpackages/emscripten/install.sh to r24306 and test clean build
#	- When builtin support for Fortran is available, remove build step
#

# Get Emscripten SDK (emsdk) driver if we have not previously installed
# Emscripten. Otherwise, just get the latest version.
if [[ ! -d ./install ]]; then
	# Get the emsdk repo
	git clone https://github.com/emscripten-core/emsdk.git

	# Move source to 'install' directory
	mv ./emsdk ./install

	cd ./install
else
	# Fetch the latest version of the emsdk
	cd ./install
	git pull
fi

# Download and install the latest SDK tools.
./emsdk install latest

# Make the "latest" SDK "active" for the current user. (writes ~/.emscripten
# file)
./emsdk activate latest

# Activate PATH and other environment variables in the current terminal
source ./emsdk_env.sh
