#!/bin/bash
set -eu


# Constants
#
VER="6.2.1"

## Environnment
#
export SQLITE3_LIBS="-lsqlite3" # SQLite3 ships with macOS

# Cleanup
rm -rf install src
mkdir install src

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "http://issm.jpl.nasa.gov/files/externalpackages/proj-${VER}.tar.gz" "proj-${VER}.tar.gz"

# Unpack source
tar -zxvf proj-$VER.tar.gz

# Move source into 'src' directory
mv proj-$VER/* src
rm -rf proj-$VER

# Configure
cd src
./configure \
	--prefix="${ISSM_DIR}/externalpackages/proj/install"

# Compile and install
if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
