#!/bin/bash
set -eu


# TODO:
# - Revisit enviroment variables (especially EMCC_CFLAGS) once support for
#	Fortran has been accomplished.
#

# Environment
export CC=emcc
export CXX=em++
export AR=emar
export RANLIB=emranlib
#export EMCC_DEBUG=1 # Uncomment to enable debugging
export EMCC_CFLAGS="-s ERROR_ON_UNDEFINED_SYMBOLS=0" # Required after v1.38.14 to avoid undefined symbol warnings from our Fortran object files being treated as errors

# Source Emscripten environment
source $ISSM_DIR/externalpackages/emscripten/install/emsdk_env.sh

#Some cleanup
rm -rf install-javascript triangle
mkdir install-javascript

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/triangle.zip' 'triangle.zip'

#Untar
cd install-javascript
cp ../triangle.zip ./
unzip triangle.zip

#copy new makefile
cp ../configs/javascript/configure.make ./
cp ../configs/javascript/makefile ./

#Patch triangle.h
patch triangle.h ../triangle.h.patch.js

#Compile triangle
make


