%Test Name: PicoMeltRate_HO
md=triangle(model(),'../Exp/Square.exp',90000.);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md.initialization.vx(:)=1.;
md.initialization.vy(:)=1.;
md.geometry.thickness(:)=500-md.mesh.x/10000;
md.geometry.bed =-100-md.mesh.x/1000;
md.geometry.base=-md.geometry.thickness*md.materials.rho_ice/md.materials.rho_water;
md.mask.groundedice_levelset=md.geometry.thickness+md.materials.rho_water/md.materials.rho_ice*md.geometry.bed;
pos=find(md.mask.groundedice_levelset>=0);
md.geometry.base(pos)=md.geometry.bed(pos);
md.geometry.surface=md.geometry.base+md.geometry.thickness;
md=extrude(md,3,1.1);
md=setflowequation(md,'HO','all');

%Set Pico Parameters
md.basalforcings = basalforcingspico(md.basalforcings);
md.basalforcings.basin_id = zeros(md.mesh.numberofelements,1);
yE = mean(md.mesh.y(md.mesh.elements),2);
pos1 = find(yE>=5e5);	 md.basalforcings.basin_id(pos1)=1;
pos2 = find(yE<5e5);     md.basalforcings.basin_id(pos2)=2;
md.basalforcings.num_basins = 2;
md.basalforcings.farocean_temperature = [271.15 272.15 273.15; 274.15 275.15 276.15; 0.5 1 1.5]; %K
md.basalforcings.farocean_salinity    = [31 32 33; 34 35 36; 0.5 1 1.5]; %PSU                
md.basalforcings.maxboxcount=5;
md.basalforcings.isplume = 0;

%Boundary conditions:
md.mask.ice_levelset=-ones(md.mesh.numberofvertices,1);
md.mask.ice_levelset(find(md.mesh.x==max(md.mesh.x)))=0;

%Model conditions
md.transient.isthermal=0;
md.transient.isstressbalance=1;
md.transient.isgroundingline=1;
md.transient.ismasstransport=1;
md.transient.issmb=1;
md.transient.requested_outputs={'default','BasalforcingsFloatingiceMeltingRate'};
md.groundingline.migration='SubelementMigration';
md.groundingline.friction_interpolation='SubelementFriction1';
md.groundingline.melt_interpolation='SubelementMelt1';
md.timestepping.final_time=1.5;
md.timestepping.time_step=0.5;

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,'Transient');

field_names     ={'Bed1','Surface1','Thickness1','Floatingice1','Vx1','Vy1','Pressure1','FloatingiceMeltingrate1',...
	   'Bed2','Surface2','Thickness2','Floatingice2','Vx2','Vy2','Pressure2','FloatingiceMeltingrate2',...
	   'Bed3','Surface3','Thickness3','Floatingice3','Vx3','Vy3','Pressure3','FloatingiceMeltingrate3'};
field_tolerances={7e-09,8e-09,8e-09,7e-09,6e-08,7e-08,6e-09,8e-10,...
	   7e-09,8e-09,8e-09,7e-09,6e-08,7e-08,6e-09,8e-10,...
	   7e-09,8e-09,8e-09,7e-09,6e-08,7e-08,6e-09,8e-10};
field_values={...
	   (md.results.TransientSolution(1).Base),...
	   (md.results.TransientSolution(1).Surface),...
	   (md.results.TransientSolution(1).Thickness),...
	   (md.results.TransientSolution(1).MaskGroundediceLevelset),...
	   (md.results.TransientSolution(1).Vx),...
	   (md.results.TransientSolution(1).Vy),...
	   (md.results.TransientSolution(1).Pressure),...
	   (md.results.TransientSolution(1).BasalforcingsFloatingiceMeltingRate),...
	   (md.results.TransientSolution(2).Base),...
	   (md.results.TransientSolution(2).Surface),...
	   (md.results.TransientSolution(2).Thickness),...
	   (md.results.TransientSolution(2).MaskGroundediceLevelset),...
	   (md.results.TransientSolution(2).Vx),...
	   (md.results.TransientSolution(2).Vy),...
	   (md.results.TransientSolution(2).Pressure),...
	   (md.results.TransientSolution(2).BasalforcingsFloatingiceMeltingRate),...
	   (md.results.TransientSolution(3).Base),...
	   (md.results.TransientSolution(3).Surface),...
	   (md.results.TransientSolution(3).Thickness),...
	   (md.results.TransientSolution(3).MaskGroundediceLevelset),...
	   (md.results.TransientSolution(3).Vx),...
	   (md.results.TransientSolution(3).Vy),...
	   (md.results.TransientSolution(3).Pressure),...
	   (md.results.TransientSolution(3).BasalforcingsFloatingiceMeltingRate),...
	   };
