/*!\file DoubleInput.c
 * \brief: implementation of the DoubleInput object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"

/*DoubleInput constructors and destructor*/
DoubleInput::DoubleInput(){/*{{{*/
	return;
}
/*}}}*/
DoubleInput::DoubleInput(int in_enum_type,IssmDouble in_value){/*{{{*/

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
DoubleInput::~DoubleInput(){/*{{{*/
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
Object* DoubleInput::copy() {/*{{{*/

	return new DoubleInput(this->enum_type,this->value);

}
/*}}}*/
void DoubleInput::DeepEcho(void){/*{{{*/

	_printf_(setw(15)<<"   DoubleInput "<<setw(25)<<left<<EnumToStringx(this->enum_type)<<" "<<this->value<<"\n");
}
/*}}}*/
void DoubleInput::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
int    DoubleInput::Id(void){ return -1; }/*{{{*/
/*}}}*/
void DoubleInput::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(DoubleInputEnum);

	MARSHALLING(enum_type);
	MARSHALLING(value);

}
/*}}}*/
int DoubleInput::ObjectEnum(void){/*{{{*/

	return DoubleInputEnum;

}
/*}}}*/

/*DoubleInput management*/
int DoubleInput::InstanceEnum(void){/*{{{*/

	return this->enum_type;

}
/*}}}*/
Input* DoubleInput::SpawnSegInput(int index1,int index2){/*{{{*/

	/*output*/
	DoubleInput* outinput=new DoubleInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;

}
/*}}}*/
Input* DoubleInput::SpawnTriaInput(int index1,int index2,int index3){/*{{{*/

	/*output*/
	DoubleInput* outinput=new DoubleInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;

}
/*}}}*/

/*Object functions*/
void DoubleInput::AXPY(Input* xinput,IssmDouble scalar){/*{{{*/

	DoubleInput*  xIssmDoubleinput=NULL;

	/*xinput is of the same type, so cast it: */
	xIssmDoubleinput=(DoubleInput*)xinput;

	/*Carry out the AXPY operation depending on type:*/
	switch(xinput->ObjectEnum()){

		case DoubleInputEnum:
			this->value=this->value+scalar*xIssmDoubleinput->value;
			return;

		default:
			_error_("not implemented yet");
	}

}
/*}}}*/
void DoubleInput::ChangeEnum(int newenumtype){/*{{{*/
	this->enum_type=newenumtype;
}
/*}}}*/
void DoubleInput::Configure(Parameters* parameters){/*{{{*/
	/*do nothing: */
}
/*}}}*/
void DoubleInput::GetInputAverage(IssmDouble* pvalue){/*{{{*/
	*pvalue=value;
}
/*}}}*/
void DoubleInput::GetInputValue(bool* pvalue){/*{{{*/
	_error_("Double input of enum " << EnumToStringx(enum_type) << " cannot return a boolean");

}
/*}}}*/
void DoubleInput::GetInputValue(int* pvalue){/*{{{*/
	_error_("Double input of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an integer");

}
/*}}}*/
void DoubleInput::GetInputValue(IssmDouble* pvalue){/*{{{*/

	/*return value*/
	*pvalue=value;
}
/*}}}*/
void DoubleInput::GetInputValue(IssmDouble* pvalue,Gauss* gauss){*pvalue=this->value;}/*{{{*/
/*}}}*/
void DoubleInput::GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist){/*{{{*/

	_error_("not supporte yet!");

}
/*}}}*/
IssmDouble DoubleInput::Max(void){/*{{{*/
	return this->value;
}
/*}}}*/
IssmDouble DoubleInput::MaxAbs(void){/*{{{*/
	return fabs(this->value);
}
/*}}}*/
IssmDouble DoubleInput::Min(void){/*{{{*/
	return this->value;
}
/*}}}*/
IssmDouble DoubleInput::MinAbs(void){/*{{{*/
	return fabs(this->value);
}
/*}}}*/
void DoubleInput::PointwiseMult(Input* xinput){/*{{{*/

	DoubleInput* xIssmDoubleinput=NULL;


	/*xinput is of the same type, so cast it: */
	xIssmDoubleinput=(DoubleInput*)xinput;

	switch(xinput->ObjectEnum()){

		case DoubleInputEnum:
			this->value=this->value*xIssmDoubleinput->value;
			return;

		default:
			_error_("not implemented yet");
	}
}
/*}}}*/
void DoubleInput::Pow(IssmDouble exponent){/*{{{*/

	if(exponent==0.0){
		/*  Not-a-number left alone Infinity set to one  */
		if (value==value)value=1.0;
	}
	else if(exponent==0.5){
		if(value>=0){
			value=sqrt(value);
		}
		else{
			value=INFINITY;
		}
	}
	else if(exponent==1.0){
		/* do nothing */
	}
	else if(exponent==-0.5){
		if(value>=0){
			value=1.0/sqrt(value);
		}
		else{
			value=INFINITY;
		}
	}
	else if(exponent==-1.0){
		if(value!=0.){
			value=1.0/value;
		}
		else{
			value=INFINITY;
		}
	}
	else {
		value=pow(value,exponent);
	}
}
/*}}}*/
void DoubleInput::Scale(IssmDouble scale_factor){/*{{{*/
	value=value*scale_factor;
}
/*}}}*/
