function output = interpRignotIceShelfMelt(X,Y,string),

switch (oshostname()),
	case {'ronne'}
		rignotmelt='/home/ModelData/Antarctica/RignotMeltingrate/Ant_MeltingRate.nc';
	case {'thwaites','murdo','astrid'}
		rignotmelt=['/home/seroussi/Data/Ant_MeltingRate.nc'];
	otherwise
		error('hostname not supported yet');
end

if nargin==2,
	string = 'melt_actual';
end

disp(['   -- Rignot Ice Shelf Melt: loading ' string]);
xdata = double(ncread(rignotmelt,'xaxis'));
ydata = double(ncread(rignotmelt,'yaxis'));

disp(['   -- Rignot Ice Shelf Melt: loading' string]);
data  = double(ncread(rignotmelt,string))';

disp(['   -- Rignot Ice Shelf Melt: interpolating ' string]);
output = InterpFromGrid(xdata,ydata,data,X(:),Y(:));
output = reshape(output,size(X,1),size(X,2));
