#!/bin/bash
set -eu


# Get Emscripten SDK (emsdk) driver if we have not previously installed
# Emscripten. Otherwise, just get the latest version.
if [[ ! -d ./emsdk ]]; then
	# Get the emsdk repo
	git clone https://github.com/emscripten-core/emsdk.git

	# Create symbolic link
	ln -s ./emsdk ./install

	cd ./emsdk
else
	# Fetch the latest version of the emsdk
	cd ./emsdk
	git pull
fi

# Download and install the latest SDK tools.
./emsdk install latest

# Make the "latest" SDK "active" for the current user. (writes ~/.emscripten
# file)
./emsdk activate latest

# Activate PATH and other environment variables in the current terminal
source ./emsdk_env.sh
