import numpy as np
#from rlist_write import *
from rlev_write import *
from MatlabArray import *
#move this later
from helpers import *


class response_function(object):
    '''
  definition for the response_function class.

  [rf] = response_function.response_function(args)
   rf = response_function()

  where the required args are:
    descriptor    (char, description, '')
  and the optional args and defaults are:
    respl         (double vector, response levels, [])
    probl         (double vector, probability levels, [])
    rell          (double vector, reliability levels, [])
    grell         (double vector, gen. reliability levels, [])

  note that zero arguments constructs a default instance, one
  argument of the class copies the instance, and one or more
  arguments constructs a new instance from the arguments.
'''

    def __init__(self):
        self.descriptor = ''
        self.respl = []
        self.probl = []
        self.rell = []
        self.grell = []

    @staticmethod
    def response_function(*args):

        nargin = len(args)
        # create a default object
        if nargin == 0:
            return response_function()

        # copy the object or create the object from the input
        else:
            if nargin == 1 and isinstance(args[0], response_function):
                rf = args[0]
            else:
                asizec = array_size(*args[0:min(nargin, 1)])
                rf = [response_function() for i in range(asizec[0]) for j in range(asizec[1])]

                for i in range(np.size(rf)):
                    if (np.size(args[0]) > 1):
                        rf[i].descriptor = args[0][i]
                    else:
                        rf[i].descriptor = str(args[0]) + string_dim(rf, i, 'vector')

                if nargin >= 2:
                    for i in range(np.size(rf)):
                        rf[i].respl = args[1]

                if nargin >= 3:
                    for i in range(np.size(rf)):
                        rf[i].probl = args[2]

                if nargin >= 4:
                    for i in range(np.size(rf)):
                        rf[i].rell = args[3]

                if nargin >= 5:
                    for i in range(np.size(rf)):
                        rf[i].grell = args[4]

                if nargin > 5:
                    print('WARNING: response_function:extra_arg: Extra arguments for object of class ' + str(type(rf)) + '.')

        return rf

    def __repr__(self):
        #  display the object
        string = '\n'
        string += 'class "response_function" object = \n'
        string += '    descriptor: ' + str(self.descriptor) + '\n'
        string += '         respl: ' + str(self.respl) + '\n'
        string += '         probl: ' + str(self.probl) + '\n'
        string += '          rell: ' + str(self.rell) + '\n'
        string += '         grell: ' + str(self.grell) + '\n'

        return string

    def __len__(self):
        return max(len(self.respl), len(self.probl), len(self.rell), len(self.grell))

    # from here on, rf is either a single, or a 1d vector of, response_function

    @staticmethod
    def prop_desc(rf, dstr):
        # response_function is always a vector, or should be, even with just 1
        if type(rf) not in [list, np.ndarray]:
            rf = [rf]

        desc = ['' for i in range(np.size(rf))]
        for i in range(np.size(rf)):
            if rf[i].descriptor != '' or type(rf[i].descriptor) != str:
                desc[i] = str(rf[i].descriptor)
            elif dstr != '':
                desc[i] = str(dstr) + str(string_dim(rf, i, 'vector'))
            else:
                desc[i] = 'rf' + str(string_dim(rf, i, 'vector'))

        desc = allempty(desc)
        return desc

    @staticmethod
    def prop_stype(rf):
        stype = []
        return stype

    @staticmethod
    def prop_scale(rf):
        scale = []
        return scale

    @staticmethod
    def prop_weight(rf):
        weight = []
        return weight

    @staticmethod
    def prop_lower(rf):
        lower = []
        return lower

    @staticmethod
    def prop_upper(rf):
        upper = []
        return upper

    @staticmethod
    def prop_target(rf):
        target = []
        return target

    @staticmethod
    def prop_levels(rf):
        # response_function is always a vector, or should be, even with just 1
        if type(rf) not in [list, np.ndarray]:
            rf = [rf]

        respl = empty_nd_list(np.size(rf))
        probl = empty_nd_list(np.size(rf))
        rell = empty_nd_list(np.size(rf))
        grell = empty_nd_list(np.size(rf))

        for i in range(np.size(rf)):
            respl[i] = rf[i].respl
            probl[i] = rf[i].probl
            rell[i] = rf[i].rell
            grell[i] = rf[i].grell

        respl = allempty(respl)
        probl = allempty(probl)
        rell = allempty(rell)
        grell = allempty(grell)
        return [respl, probl, rell, grell]

    @staticmethod
    def dakota_write(fidi, dresp, rdesc):
        # collect only the responses of the appropriate class
        rf = [struc_class(vars(dresp)[i][j], 'response_function', 'rf') for i in fieldnames(dresp) for j in range(len(vars(dresp)[i]))]

        #possible namespace pollution here
        from rlist_write import rlist_write
        # write responses
        rdesc = rlist_write(fidi, 'response_function', 'rf', rf, rdesc)

        return rdesc

    @staticmethod
    def dakota_rlev_write(fidi, dresp, params):
        # collect only the responses of the appropriate class
        rf = [struc_class(vars(dresp)[i][j], 'response_function', 'rf') for i in fieldnames(dresp) for j in range(len(vars(dresp)[i]))]

        # write response levels
        rlev_write(fidi, rf, 'response_function', params)
