from checkfield import checkfield
from WriteData import WriteData
from fielddisplay import fielddisplay


class frontalforcingsrignot(object):
    """
    FRONTAL FORCINGS Rignot class definition

       Usage:
          frontalforcingsrignot = frontalforcingsrignot()
    """

    def __init__(self):  # {{{
        self.basin = float('NaN')
        self.numberofbasins = 0.
        self.subglacial_discharge = float('NaN')
        self.thermalforcing = float('NaN')

    #set defaults
        self.setdefaultparameters()

    #}}}

    def __repr__(self):  # {{{
        string = '   Frontalforcings parameters:'
        string = "%s\n%s" % (string, fielddisplay(self, 'basin', 'basin ID for vertices'))
        string = "%s\n%s" % (string, fielddisplay(self, 'numberofbasins', 'number of basins'))
        string = "%s\n%s" % (string, fielddisplay(self, 'subglacial_discharge', 'sum of subglacial discharge for each basin [m / d]'))
        string = "%s\n%s" % (string, fielddisplay(self, 'thermalforcing', 'thermal forcing [C]'))

        return string
    #}}}

    def extrude(self, md):  # {{{
        return self
    #}}}

    def setdefaultparameters(self):  # {{{

        return self
    #}}}

    def checkconsistency(self, md, solution, analyses):  # {{{
        #Early return
        if (solution != 'TransientSolution') or (not md.transient.ismovingfront):
            return md

        md = checkfield(md, 'fieldname', 'frontalforcings.basin', '>', 0, 'nan', 1, 'Inf', 1)
        md = checkfield(md, 'fieldname', 'frontalforcings.numberofbasins', 'numel', [1])
        md = checkfield(md, 'fieldname', 'frontalforcings.subglacial_discharge', '>=', 0, 'nan', 1, 'Inf', 1, 'timeseries', 1)
        md = checkfield(md, 'fieldname', 'frontalforcings.thermalforcing', 'nan', 1, 'Inf', 1, 'timeseries', 1)
        return md
    # }}}

    def marshall(self, prefix, md, fid):  # {{{
        WriteData(fid, prefix, 'name', 'md.frontalforcings.parameterization', 'data', 2, 'format', 'Integer')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'basin', 'format', 'DoubleMat', 'mattype', 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'numberofbasins', 'format', 'Integer')
        WriteData(fid, prefix, 'object', self, 'fieldname', 'subglacial_discharge', 'format', 'DoubleMat', 'mattype', 1, 'timeserieslength', md.mesh.numberofvertices + 1)
        WriteData(fid, prefix, 'object', self, 'fieldname', 'thermalforcing', 'format', 'DoubleMat', 'mattype', 1, 'timeserieslength', md.mesh.numberofvertices + 1)

    # }}}
