#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.6.3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.6.3.tar.gz' 'petsc-3.6.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.6.3.tar.gz
mv petsc-3.6.3/* src/
rm -rf petsc-3.6.3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="/global/hds/software/cpu/eb3/imkl/11.2.3.187-iimpi-7.3.5-GNU-4.9.3-2.25/mkl/" \
	--with-mpi-lib="/global/hds/software/cpu/eb3/impi/5.0.3.048-iccifort-2015.3.187-GNU-4.9.3-2.25/lib64/libmpi.so" \
	--with-mpi-include="/global/hds/software/cpu/eb3/impi/5.0.3.048-iccifort-2015.3.187-GNU-4.9.3-2.25/include64/" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#!/bin/bash
#SBATCH -J petscinstall # Job Name
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -t 00:01:00 # Run time (hh:mm:ss) - 1.5 hours
#SBATCH --qos=devel
#SBATCH -o petscinstall.outlog
#SBATCH -e petscinstall.errlog

module purge
module load CMake/3.3.2-GNU-4.9.3-2.25
module load Automake/1.15-GNU-4.9.3-2.25
module load libtool/2.4.6-GNU-4.9.3-2.25
module load intel/2015b

mpirun -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== sbatch script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
