#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.6.3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/petsc-lite-3.6.3.tar.gz' 'petsc-3.6.3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.6.3.tar.gz
mv petsc-3.6.3/* src/
rm -rf petsc-3.6.3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-blas-lapack-dir="$TACC_MKL_LIB" \
	--with-mpi-lib="/opt/cray/pe/mpt/7.7.3/gni/mpich-intel/16.0/lib/libmpich.so" \
	--with-mpi-include="/opt/cray/pe/mpt/7.7.3/gni/mpich-intel/16.0/include" \
	--known-mpi-shared-libraries=1 \
	--with-debugging=0 \
	--with-valgrind=0 \
	--with-x=0 \
	--with-ssl=0 \
	--with-batch=1  \
	--with-shared-libraries=1 \
	--download-metis=1 \
	--download-parmetis=1 \
	--download-mumps=1 \
	--download-scalapack=1 

#prepare script to reconfigure petsc
cat > script.queue << EOF
#!/bin/bash		 
#SBATCH -J petscinstall # Job Name
#SBATCH -n 24 # Requests 12 tasks/node, 12 cores total
#SBATCH -N 1 # Requests 12 tasks/node, 12 cores total
#SBATCH -p normal # Queue name normal
#SBATCH -t 00:01:00 # Run time (hh:mm:ss) - 1.5 hours

ibrun -np 1 ./conftest-arch-linux2-c-opt
EOF

#print instructions
echo "== Now: cd src/ "
echo "== sbatch script.queue "
echo "== Then run reconfigure script generated by PETSc and follow instructions"
