#!/bin/bash
set -eu

VER="1.8.9"

# Cleanup
rm -rf src install hdf5-${VER}
mkdir src install

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh "https://issm.ess.uci.edu/files/externalpackages/hdf5-${VER}.tar.gz" "hdf5-${VER}.tar.gz"

# Untar source
tar -zxvf  hdf5-${VER}.tar.gz

# Move source to src directory
rm -rf src/*
mv hdf5-${VER}/* src/
rm -rf hdf5-${VER}

# This project uses C code with C++-style comments. As such, we need to specify
# a C standard that supports them.
export CFLAGS='-std=c99'

# Configure, compile, and install
cd src
./configure \
	--prefix="$ISSM_DIR/externalpackages/hdf5/install"

if [ $# -eq 0 ]; then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
