#!/bin/bash

MATLAB_PATH="/usr/local/MATLAB/R2015a"
PACKAGE="ISSM" # Name of directory to copy distributable files to
TARBALL_NAME="issm-ubuntu"
TARBALL=$TARBALL_NAME.tar.gz

# Clean up from previous packaging
echo "Cleaning up existing assets"
cd $ISSM_DIR
rm -rf $PACKAGE
mkdir $PACKAGE

# Add/modify required binaries
cd $ISSM_DIR/bin

echo "Modify generic"
cat generic_static.m | sed -e "s/generic_static/generic/g" > generic.m

echo "Moving mpiexec to bin"
if [ -f ../externalpackages/mpich/install/bin/mpiexec ]; then
	cp ../externalpackages/mpich/install/bin/mpiexec .
	cp ../externalpackages/mpich/install/bin/hydra_pmi_proxy .
else
	echo "mpich not found"
fi

echo "Moving gmsh to bin"
if [ -f ../externalpackages/gmsh/install/gmsh ]; then
	cp ../externalpackages/gmsh/install/gmsh .
else
	echo "gmsh not found"
fi

# Check that test101 runs
cd $ISSM_DIR/test/NightlyRun
rm matlab.log
$MATLAB_PATH/bin/matlab -nojvm -nosplash -r "try, addpath $ISSM_DIR/bin $ISSM_DIR/lib; runme('id',101);exit; catch me,fprintf('%s',getReport(me)); exit; end" -logfile matlab.log

if [[ $(cat matlab.log | grep -c SUCCESS) -lt 10 ]]; then
	echo "test101 FAILED"
	exit 1;
else
	echo "test101 PASSED"
fi

echo "Creating tarball: ${TARBALL_NAME}"
cd $ISSM_DIR
rm -f $TARBALL
cp -rf bin lib test examples scripts $PACKAGE/
tar -czf $TARBALL $PACKAGE
ls -lah $TARBALL

echo "Shipping binaries to website"

# We're using public key authentication method to upload the tarball The
# following lines check to see if the SSH Agent is running. If not, then it is
# started and relevant information is forwarded to a script.
pgrep "ssh-agent" > /dev/null
if [ $? -ne 0 ]; then
	echo "SSH Agent is not running. Starting it..."
	ssh-agent > ~/.ssh/agent.sh
else
	echo "SSH Agent is running..."
fi

source ~/.ssh/agent.sh
ssh-add ~/.ssh/ubuntu-bins_jenkins-to-ross

scp $TARBALL ross.ics.uci.edu:/var/www/html/$TARBALL

if [ $? -ne 0 ]; then
	echo "The upload failed."
	echo "Perhaps the SSH Agent was started by some other means."
	echo "Try killing the agent and running again."
fi
