#!/bin/bash
set -eu

# Constants
DAK_VER="6.2"

#Some cleanup
rm -rf Dakota
rm -rf src
rm -rf build
rm -rf install
mkdir src build install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.sh https://issm.ess.uci.edu/files/externalpackages/dakota-${DAK_VER}-public.src.tar.gz dakota-${DAK_VER}-public-src.tar.gz

#Untar
tar -zxvf dakota-${DAK_VER}-public-src.tar.gz

#Move Dakota to src directory
mv dakota-${DAK_VER}.0.src/* src
rm -rf dakota-${DAK_VER}.0.src

#Set up Dakota cmake variables and config
DAK_PATH=$ISSM_DIR/externalpackages/dakota

export DAK_BUILD=$DAK_PATH/build
export DAK_INSTALL=$DAK_PATH/install
export DAK_SRC=$DAK_PATH/src
export MPIHOME=$ISSM_DIR/externalpackages/mpich/install
export BOOST_ROOT=$ISSM_DIR/externalpackages/boost/install

cp $DAK_SRC/cmake/BuildDakotaTemplate.cmake $DAK_SRC/cmake/BuildDakotaCustom.cmake
patch $DAK_SRC/cmake/BuildDakotaCustom.cmake configs/${DAK_VER}/BuildDakotaCustom.cmake.patch
patch $DAK_SRC/cmake/DakotaDev.cmake configs/${DAK_VER}/DakotaDev.cmake.patch
patch $DAK_SRC/CMakeLists.txt configs/${DAK_VER}/CMakeLists.txt.petsclibs.patch

#Apply patches
patch src/src/NonDSampling.cpp configs/${DAK_VER}/NonDSampling.cpp.patch
patch src/src/NonDLocalReliability.cpp configs/${DAK_VER}/NonDLocalReliability.cpp.patch
patch src/packages/pecos/src/pecos_global_defs.hpp configs/${DAK_VER}/pecos_global_defs.hpp.patch

#Setting CXXFLAGS to deal with C++11 incompatibility with Matlab's Boost
export CXXFLAGS='-std=c++98'

#Configure dakota
cd $DAK_BUILD

cmake -C$DAK_SRC/cmake/BuildDakotaCustom.cmake \
		-C$DAK_SRC/cmake/DakotaDev.cmake \
		-DBUILD_STATIC_LIBS=ON \
		-DBUILD_SHARED_LIBS=OFF \
		-DBOOST_ROOT=$BOOST_ROOT \
		-DBoost_LIBRARY_DIRS=$BOOST_ROOT/lib \
		-DBoost_NO_BOOST_CMAKE=TRUE \
		-DBoost_NO_SYSTEM_PATHS=TRUE \
		-DBoost_INSTALL_PREFIX=$DAK_INSTALL \
		-DCMAKE_C_FLAGS="-O2 -g -fPIC" \
		-DCMAKE_CXX_FLAGS="-O2 -g -fPIC" \
		-DCMAKE_Fortran_FLAGS="-O2 -g -fPIC" \
		-DCMAKE_C_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicc \
		-DCMAKE_CXX_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpicxx \
		-DCMAKE_Fortran_COMPILER=$ISSM_DIR/externalpackages/mpich/install/bin/mpif77 \
		-DHAVE_ACRO=off \
		-DHAVE_JEGA=off \
		$DAK_SRC
cd ..

#Compile and install dakota
cd $DAK_BUILD

if [ $# -eq 0 ];
then
	make
	make install
else
	make -j $1
	make -j $1 install
fi

cd ..
