#!/bin/bash
set -eu

# Some cleanup
rm -rf install

# Download source
$ISSM_DIR/scripts/DownloadExternalPackage.sh 'https://issm.ess.uci.edu/files/externalpackages/emsdk-portable.tar.gz' 'emsdk-portable.tar.gz'

# Untar and move source to install directory
tar -zxvf emsdk-portable.tar.gz

mv emsdk_portable install

cd install

# Download and install the latest SDK tools
./emsdk update

# Make the "latest" SDK "active" for the current user. (writes ~/.emscripten file)
# NOTE: See revision history for version that we used to hard code in.
./emsdk install sdk-tag-1.34.12-64bit
./emsdk activate sdk-tag-1.34.12-64bit

# Activate PATH and other environment variables in the current terminal
source emsdk_env.sh
