#Test Name: LovenumberstAtDepth.
#Same as test  #1 of test2084.m

from model import *
from socket import gethostname
from solve import *
from numpy import *
from generic import generic
from materials import *

md = model()
md.cluster = generic('name', gethostname(), 'np', 1)

md.materials = materials('litho')
md.miscellaneous.name = 'FourierLoveTest'
md.groundingline.migration = 'None'

md.verbose = verbose('111111101')
cst = 365.25 * 24 * 3600 * 1000

md.materials.numlayers = 6
md.materials.radius = np.array([10, 1222.5, 3.4800e+03, 5.7010e+03, 5.9510e+03, 6.3010e+03, 6.3710e+03]).reshape(-1, 1) * 1e3
md.materials.density = np.array([1.0750e4, 1.0750e+04, 4.9780e+03, 3.8710e+03, 3.4380e+03, 3.0370e+03]).reshape(- 1, 1)
md.materials.lame_mu = np.array([1e-5, 0, 2.2834e+00, 1.0549e+00, 7.0363e-01, 5.0605e-01]).reshape(- 1, 1) * 1e11
md.materials.viscosity = np.array([0, 0, 2.0000e+00, 1.0000e+00, 1.0000e+00, 1.0000e+25]).reshape(- 1, 1) * 1e21
md.materials.lame_lambda = np.array(md.materials.lame_mu) * 0 + 5e14
md.materials.issolid = np.array([1, 0, 1, 1, 1, 1]).reshape(- 1, 1)
md.materials.isburgers = np.zeros((md.materials.numlayers)).reshape(- 1, 1)

md.love.love_kernels = 1
md.love.allow_layer_deletion = 1
md.love.frequencies = (np.array([0]) * 2 * pi).reshape(- 1, 1) / cst
md.love.nfreq = len(md.love.frequencies)
md.love.sh_nmax = 2

md.materials.burgers_mu = md.materials.lame_mu
md.materials.burgers_viscosity = md.materials.viscosity

md = solve(md, 'lv')

#Fields and tolerances to track changes
#loading love numbers
field_names = ['LoveH_loading_elastic', 'LoveK_loading_elastic', 'LoveL_loading_elastic', 'LoveKernels_degree1', 'LoveKernels_degree2']
field_tolerances = [1e-10, 1e-10, 1e-10, 1e-10, 1e-10]
field_values = [md.results.LoveSolution.LoveHr[:, 0],
                md.results.LoveSolution.LoveKr[:, 0],
                md.results.LoveSolution.LoveLr[:, 0],
                md.results.LoveSolution.LoveKernelsReal[1, 0, :, :],
                md.results.LoveSolution.LoveKernelsReal[2, 0, :, :]]
