#Test Name: EarthSlr_rotationalFeedback
import numpy as np
from model import *
from socket import gethostname
from solve import *
from gmshplanet import *
from love_numbers import *
from paterson import *
from maskpsl import *
from gmtmask import *

#mesh earth:
md = model()
md.mesh = gmshplanet('radius', 6.371012 * 1e3, 'resolution', 1000.)  #500 km resolution mesh

#parameterize slr solution:
#slr loading:  {{{
md.slr.deltathickness = np.zeros((md.mesh.numberofelements, ))
md.slr.sealevel = np.zeros((md.mesh.numberofvertices, ))
md.slr.steric_rate = np.zeros((md.mesh.numberofvertices, ))

#antarctica
#Access every element in lat using the indices in elements
# - 1 to convert to base 0 indexing, 1 (not 2, in matlab) to sum over rows
late = sum(md.mesh.lat[md.mesh.elements - 1], 1) / 3
longe = sum(md.mesh.long[md.mesh.elements - 1], 1) / 3
pos = np.intersect1d(np.array(np.where(late < - 75)), np.array(np.where(longe < 0)))
md.slr.deltathickness[pos] = - 1

#elastic loading from love numbers:
nlov = 1000
md.slr.love_h = np.array(love_numbers('h'))
md.slr.love_h = np.resize(md.slr.love_h, nlov + 1)
md.slr.love_k = np.array(love_numbers('k'))
md.slr.love_k = np.resize(md.slr.love_k, nlov + 1)
md.slr.love_l = np.array(love_numbers('l'))
md.slr.love_l = np.resize(md.slr.love_l, nlov + 1)
#}}}

#mask:  {{{
md.mask = maskpsl()  # use maskpsl class (instead of mask) to store the ocean function as a ocean_levelset
mask = gmtmask(md.mesh.lat, md.mesh.long)

icemask = np.ones((md.mesh.numberofvertices, ))
pos = np.where(mask == 0)
#pos[0] because np.where(mask = 0) returns a 2d array, the latter parts of which are all array / s of 0s
icemask[pos[0]] = - 1
pos = np.where(sum(mask[md.mesh.elements - 1], 1) < 3)
icemask[md.mesh.elements[pos, :] - 1] = - 1
md.mask.ice_levelset = icemask
md.mask.ocean_levelset = np.zeros((md.mesh.numberofvertices, ))
pos = np.where(md.mask.ice_levelset == 1)
md.mask.ocean_levelset[pos] = 1

#make sure that the ice level set is all inclusive:
md.mask.land_levelset = np.zeros((md.mesh.numberofvertices, ))
md.mask.groundedice_levelset = - np.ones((md.mesh.numberofvertices, ))

#make sure that the elements that have loads are fully grounded:
pos = np.nonzero(md.slr.deltathickness)[0]
md.mask.groundedice_levelset[md.mesh.elements[pos, :] - 1] = 1

#make sure wherever there is an ice load, that the mask is set to ice:
icemask[md.mesh.elements[pos, :] - 1] = - 1
md.mask.ice_levelset = icemask
# }}}

# use model representation of ocea area (not the ture area)
md.slr.ocean_area_scaling = 0

#geometry
di = md.materials.rho_ice / md.materials.rho_water
md.geometry.thickness = np.ones((md.mesh.numberofvertices, ))
md.geometry.surface = (1 - di) * np.zeros((md.mesh.numberofvertices, ))
md.geometry.base = md.geometry.surface - md.geometry.thickness
md.geometry.bed = md.geometry.base

#materials
md.initialization.temperature = 273.25 * np.ones((md.mesh.numberofvertices, ))
md.materials.rheology_B = paterson(md.initialization.temperature)
md.materials.rheology_n = 3 * np.ones((md.mesh.numberofelements, ))

#Miscellaneous
md.miscellaneous.name = 'test2003'

#New stuff
md.slr.spcthickness = np.nan * np.ones((md.mesh.numberofvertices, ))
md.slr.Ngia = np.zeros((md.mesh.numberofvertices, ))
md.slr.Ugia = np.zeros((md.mesh.numberofvertices, ))

#Solution parameters
md.slr.reltol = float('NaN')
md.slr.abstol = 1e-3
md.slr.geodetic = 1

#eustatic + rigid + elastic run:
md.slr.rigid = 1
md.slr.elastic = 1
md.slr.rotation = 0
md.cluster = generic('name', gethostname(), 'np', 3)
#md.verbose = verbose('111111111')
#print md.calving
#print md.gia
#print md.love
#print md.esa
#print md.autodiff
md = solve(md, 'Sealevelrise')
SnoRotation = md.results.SealevelriseSolution.Sealevel

#eustatic + rigid + elastic + rotation run:
md.slr.rigid = 1
md.slr.elastic = 1
md.slr.rotation = 1
md.cluster = generic('name', gethostname(), 'np', 3)
#md.verbose = verbose('111111111')
md = solve(md, 'Sealevelrise')
SRotation = md.results.SealevelriseSolution.Sealevel

#Fields and tolerances to track changes
field_names = ['noRotation', 'Rotation']
field_tolerances = [1e-13, 1e-13]
field_values = [SnoRotation, SRotation]
