/*!\file Radar.cpp
 * \brief: Radar Object
 */

/*Headers:*/
#ifdef HAVE_CONFIG_H
   #include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "./classes.h"
#include "./Elements/Element.h"
#include "./Elements/Elements.h"
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/Results.h"
#include "../datastructures/datastructures.h"
#include "./FemModel.h"
#include "../classes/Params/Parameters.h"
#include "../classes/Inputs/Input.h"
#include "../classes/gauss/Gauss.h"
#include "./Radar.h"

/*Radar constructors, destructors :*/
Radar::Radar(){/*{{{*/
	this->definitionenum = -1;
	this->name = NULL;
}
/*}}}*/
Radar::Radar(char* in_name, int in_definitionenum){/*{{{*/	
	this->definitionenum=in_definitionenum;
	this->name		= xNew<char>(strlen(in_name)+1);
	xMemCpy<char>(this->name,in_name,strlen(in_name)+1);
}
/*}}}*/
Radar::~Radar(){/*{{{*/
	if(this->name)xDelete(this->name);
}
/*}}}*/
/*Object virtual function resolution: */
Object* Radar::copy() {/*{{{*/
	Radar* out =new Radar(this->name,this->definitionenum);
	return (Object*)out;
}
/*}}}*/
void Radar::DeepEcho(void){/*{{{*/
	this->Echo();
}
/*}}}*/
void Radar::Echo(void){/*{{{*/
	_printf_(" Radar: " << name << " " << this->definitionenum << "\n");
}
/*}}}*/
int Radar::Id(void){/*{{{*/
	return -1;
}
/*}}}*/
void Radar::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){/*{{{*/
	_error_("not implemented yet!"); 
} 
/*}}}*/
int Radar::ObjectEnum(void){/*{{{*/
	return RadarEnum;
}
/*}}}*/
/*Definition virtual function resolutoin: */
int Radar::DefinitionEnum(){/*{{{*/
	return this->definitionenum;
}
/*}}}*/
char* Radar::Name(){/*{{{*/
	char* name2=xNew<char>(strlen(this->name)+1);
	xMemCpy(name2,this->name,strlen(this->name)+1);
	return name2;
}
/*}}}*/
IssmDouble Radar::Response(FemModel* femmodel){/*{{{*/	
	int i; 
	for(i=0;i<femmodel->elements->Size();i++){
		Element* element=(Element*)femmodel->elements->GetObjectByOffset(i);
		element->ComputeRadarAttenuation();
		element->ComputeRadarPower(); 
	}
	return 0.;
}
	/*}}}*/

