%  --  startup --
system('ln -s $ISSM_DIR/startup.m .'); startup;
startup;
%  --  vim --
!vim Pig.par
!vim Square.par
!vim Basin.par
!vim Antarctica.par
!vim runme.m
!vim configuration.m
%  --  execution --
runme
md.analysis_type=DiagnosticAnalysisEnum;
md.sub_analysis_type=NoneAnalysisEnum;
md=solve(md,'analysis_type','diagnostic');
md=loadresultsfromcluster(md);
%  --  tests  --
md=runme('analysis_type',{'diagnostic'});
md=runme('analysis_type',{'diagnostic'},'parallel',1);
runme('analysis_type',{'diagnostic'});
%  --  tweak parameters --
md.eps_res=0.01;
md.eps_rel=0.01;
md.eps_abs=NaN;
md.connectivity=100;
md.numberofelements
md.numberofgrids
%  --  model set up  --
md=extrude(md,8,3);
md=setelementstype(md,'pattyn','all','stokes','all');
md=setelementstype(md,'macayeal','all');
md=solve(md,'analysis_type','diagnostic','batch','yes');
md=solve(md,'analysis_type','thermal');
md=solve(md,'analysis_type','thermal','batch','yes');
%  --  plots  --
plotmodel(md,'data',md.results.diagnostic.vel)
print -dpng vel.png
%  --  setup --
md=model;
md=parameterize(md,'Antarctica.par');
md=geography(md,'','');
md=geography(md,'Iceshelves.exp','Islands.exp');
md=extrude(md,8,1);
md=mesh(md,'DomainOutline.exp',5000);
