/*!\file:  InterpFromMeshToMesh2dx.cpp
 * \brief  "c" core code for interpolating values from a structured grid.
 */ 


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./InterpFromMeshToMesh2dx.h"
#include "../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "InterpFromMeshToMesh2dx"
int InterpFromMeshToMesh2dx( Vec* pdata_prime,double* index_data, double* x_data, double* y_data, int nods_data,int nels_data, double* data, int data_length, double* x_prime, double* y_prime, int nods_prime,double default_value){

	/*Output*/
	Vec data_prime=NULL;

	/*Intermediary*/
	int i;
	int interpolation_type;
	bool debug;
	double x_prime_min,x_prime_max;
	double y_prime_min,y_prime_max;

	/*threading: */
	InterpFromMeshToMesh2dxThreadStruct gate;
	const int num=_NUMTHREADS_;

	/*some checks*/
	if (nels_data<1 || nods_data<3 || nods_prime==0){
		throw ErrorException(__FUNCT__,"nothing to be done according to the mesh given in input");
	}

	/*Set debug to 1 if there are lots of elements*/
	debug=(bool)((double)nels_data*(double)nods_prime >= pow((double)10,(double)9));

	/*figure out what kind of interpolation is needed*/
	if (data_length==nods_data){
		interpolation_type=1;
	}
	else if (data_length==nels_data){
		interpolation_type=2;
	}
	else{
		throw ErrorException(__FUNCT__,"length of vector data not supported yet. It should be of length (number of nodes) or (number of elements)!");
	}

	/*Get prime mesh extrema coordinates*/
	x_prime_min=x_prime[0]; x_prime_max=x_prime[0];y_prime_min=y_prime[0]; y_prime_max=y_prime[0];
	for (i=1;i<nods_prime;i++){
		if (x_prime[i]<x_prime_min) x_prime_min=x_prime[i];
		if (x_prime[i]>x_prime_max) x_prime_max=x_prime[i];
		if (y_prime[i]<y_prime_min) y_prime_min=y_prime[i];
		if (y_prime[i]>y_prime_max) y_prime_max=y_prime[i];
	}

	/*Initialize output*/
	data_prime=NewVec(nods_prime);
	for (i=0;i<nods_prime;i++) VecSetValue(data_prime,i,default_value,INSERT_VALUES);

	/*initialize thread parameters: */
	gate.debug=debug;
	gate.nods_prime=nods_prime;
	gate.nels_data=nels_data;
	gate.x_data=x_data;
	gate.y_data=y_data;
	gate.index_data=index_data;
	gate.x_prime=x_prime;
	gate.y_prime=y_prime;
	gate.data=data;
	gate.interpolation_type=interpolation_type;
	gate.default_value=default_value;
	gate.data_prime=data_prime;
	gate.x_prime_min=x_prime_min;
	gate.x_prime_max=x_prime_max;
	gate.y_prime_min=y_prime_min;
	gate.y_prime_max=y_prime_max;

	/*launch the thread manager with InterpFromMeshToMesh2dxt as a core: */
	LaunchThread(InterpFromMeshToMesh2dxt,(void*)&gate,num);

	/*Assign output pointers:*/
	*pdata_prime=data_prime;
}



