function cmap = paraview(m)

J=[...
0.0 59 76 192
0.03125 68 90 204
0.0625 77 104 215
0.09375 87 117 225
0.125 98 130 234
0.15625 108 142 241
0.1875 119 154 247
0.21875 130 165 251
0.25 141 176 254
0.28125 152 185 255
0.3125 163 194 255
0.34375 174 201 253
0.375 184 208 249
0.40625 194 213 244
0.4375 204 217 238
0.46875 213 219 230
0.5 221 221 221
0.53125 229 216 209
0.5625 236  211 197
0.59375 241 204 185
0.625 245   196 173
0.65625 247 187 160
0.6875 247  177 148
0.71875 247 166 135
0.75 244    154 123
0.78125 241 141 111
0.8125 236  127 99 
0.84375 229 112 88 
0.875 222   96  77 
0.90625 213 80  66 
0.9375 203  62  56 
0.96875 192 40  47 
1.0 180     4   38 ];

l = length(J);
if nargin < 1
	n = 256;
end
cmap = interp1(1:l,J(:,2:4)/255,linspace(1,l,n),'*linear');
