/* \file NyeH2O.cpp
 * brief figure out B of H2O ice for a certain temperature
 *		INPUT function B=NyeH2O(temperature)
 *    	where rigidigty (in s^(1/3)Pa) is the flow law paramter in the flow law sigma=B*e(1/3) (Nye, p -COMPLETE- ). 

 VALUES CALCULATED USING THE FOLLOWING MATLAB CODE

 Rg = 8.3144598; % J mol^-1 K^-1
 A_const = 9e4; % s^-1 MPa
 Q = 60000; % J mol^-1
 n = 3; % Glen's exponent
 T = -102.5:5:2.5; T = T + 273; % K
 A = A_const*exp(-Q./(T*Rg)); % s^-1 MPa
 B = A.^(-1/n)*1e6; % s^(1/n) Pa
 */

#include <math.h>
#include "../Numerics/types.h"

IssmDouble NyeH2O(IssmDouble temperature){

	/*Coefficients*/
	const IssmPDouble Rg      = 8.3144598; /* J mol^-1 K^-1 */
	const IssmPDouble A_const = 9.e4;      /*s^-1 MPa       */
	const IssmPDouble Q       = 60000.;    /*J mol^-1       */
	const IssmPDouble n       = 3.;        /*Glen's exponent*/

	/*Arrhenius Law*/
	IssmDouble A = A_const *exp(-Q/(temperature*Rg)); /*s^-1 MPa   */
	IssmDouble B = 1e6*pow(A,-1/n);                    /*s^(1/n) Pa */

	/*Return output*/
	return B;
}
