/* \file NyeCO2.cpp
 * \	brief figure out B of CO2 ice for a certain temperature
 *		INPUT function B=NyeCO2(temperature)
 *    	where rigidigty (in s^(1/3)Pa) is the flow law paramter in the flow law sigma=B*e(1/3) (Nye, p -COMPLETE- ). 

 VALUES CALCULATED USING THE FOLLOWING MATLAB CODE

 Rg = 8.3144598; % J mol^-1 K^-1
 A_const = 10^(10.8); % s^-1 MPa
 Q = 63000; % J mol^-1
 n = 7; % Glen's exponent
 T = 97.5:5:252.5; % K
 A = A_const*exp(-Q./(T*Rg)); % s^-1 MPa
 B = A.^(-1/n)*1e6; % s^(1/n) Pa
 */

#include <math.h>
#include "../Numerics/types.h"

IssmDouble NyeCO2(IssmDouble temperature){

	IssmDouble B,T;

	T=temperature;

	if(T<=100.0){
		B=1899806746.55828;
	}
	else if((T>=100.0) && (T<=105.0)){
		B=1105378610.10266;
	}
	else if((T>=105.0) && (T<=110.0)){
		B=676381320.528217;
	}
	else if((T>=110.0) && (T<=115.0)){
		B=432348426.904519;
	}
	else if((T>=115.0) && (T<=120.0)){
		B=287089456.910568;
	}
	else if((T>=120.0) && (T<=125.0)){
		B=197113445.038555;
	}
	else if((T>=125.0) && (T<=130.0)){
		B=139387289.896988;
	}
	else if((T>=130.0) && (T<=135.0)){
		B=101178460.700527;
	}
	else if((T>=135.0) && (T<=140.0)){
		B=75174730.2531849;
	}
	else if((T>=140.0) && (T<=145.0)){
		B=57030799.0697205;
	}
	else if((T>=145.0) && (T<=150.0)){
		B=44083907.2876590;
	}
	else if((T>=150.0) && (T<=155.0)){
		B=34656426.3665295;
	}
	else if((T>=155.0) && (T<=160.0)){
		B=27664457.7106089;
	}
	else if((T>=160.0) && (T<=165.0)){
		B=22391479.9130613;
	}
	else if((T>=165.0) && (T<=170.0)){
		B=18353816.3612526;
	}
	else if((T>=170.0) && (T<=175.0)){
		B=15218650.2018789;
	}
	else if((T>=175.0) && (T<=180.0)){
		B=12752901.3547654;
	}
	else if((T>=180.0) && (T<=185.0)){
		B=10790666.8437103;
	}
	else if((T>=185.0) && (T<=190.0)){
		B=9212075.16184763;
	}
	else if((T>=190.0) && (T<=195.0)){
		B=7929303.02671413;
	}
	else if((T>=195.0) && (T<=200.0)){
		B=6877172.17359016;
	}
	else if((T>=200.0) && (T<=205.0)){
		B=6006726.68822080;
	}
	else if((T>=205.0) && (T<=210.0)){
		B=5280781.91812612;
	}
	else if((T>=210.0) && (T<=215.0)){
		B=4670797.58917498;
	}
	else if((T>=215.0) && (T<=220.0)){
		B=4154653.09694929;
	}
	else if((T>=220.0) && (T<=225.0)){
		B=3715045.71619004;
	}
	else if((T>=225.0) && (T<=230.0)){
		B=3338324.34308717;
	}
	else if((T>=230.0) && (T<=235.0)){
		B=3013631.36885997;
	}
	else if((T>=235.0) && (T<=240.0)){
		B=2732264.98697388;
	}
	else if((T>=240.0) && (T<=245.0)){
		B=2487200.85823651;
	}
	else if((T>=245.0) && (T<=250.0)){
		B=2272730.12712433;
	}
	else{
		B=2084183.18884150;
	}

	return B;
}
