function display(plotoptions)
%DISPLAY - displays the fields of a plotoptions element
%
%   echo function for 'plotoptions' class

disp(sprintf('\n%s = \n',inputname(1)));
disp(sprintf('   numberofplots: %i',plotoptions.numberofplots));
if ~isempty(plotoptions.list),
	disp(sprintf('   list: (%ix%i)',size(plotoptions.list,1),size(plotoptions.list,2)));
	for i=1:size(plotoptions.list,1),
		unit=plotoptions.list{i};
		disp(sprintf('\n   options of plot number %i',i));
		for j=1:size(unit.list,1)
			if ischar(unit.list{j,2}),
				disp(sprintf('     field: %-10s value: ''%s''',unit.list{j,1},unit.list{j,2}));
			elseif isnumeric(unit.list{j,2}) & length(unit.list{j,2})==1,
				disp(sprintf('     field: %-10s value: %g',unit.list{j,1},unit.list{j,2}));
			else
				disp(sprintf('     field: %-10s value: (%ix%i)',unit.list{j,1},size(unit.list{j,2},1),size(unit.list{j,2},2)));
			end
		end
	end
else
	disp(sprintf('   list: empty'));
end
